/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.PrintStream;
import java.text.NumberFormat;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceSearchTests;
import org.eclipse.jdt.internal.core.search.processing.IJob;

public class FullSourceWorkspaceCompleteSearchTests
extends FullSourceWorkspaceSearchTests {
    private static int TESTS_COUNT = 0;
    private static final int ITERATIONS_COUNT = 0;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    static final long MAX_MEM = 0x20000000L;

    public static Test suite() {
        Test suite = FullSourceWorkspaceCompleteSearchTests.buildSuite(FullSourceWorkspaceCompleteSearchTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceCompleteSearchTests.createPrintStream(FullSourceWorkspaceCompleteSearchTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        FullSourceWorkspaceCompleteSearchTests.verifyVmArguments();
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceCompleteSearchTests.class;
    }

    private static void verifyVmArguments() {
        StringBuffer buffer = null;
        NumberFormat floatFormat = NumberFormat.getNumberInstance();
        floatFormat.setMaximumFractionDigits(1);
        long maxMem = Runtime.getRuntime().maxMemory();
        boolean tooMuch = false;
        if ((double)maxMem < 5.2613349376E8 || (tooMuch = (double)maxMem > 5.4760833024E8)) {
            if (buffer == null) {
                buffer = new StringBuffer("WARNING: Performance tests results may be invalid !!!\n");
            }
            buffer.append("\t- ");
            buffer.append(tooMuch ? "too much " : "not enough ");
            buffer.append("max memory allocated (");
            buffer.append(floatFormat.format((double)maxMem / 1024.0 / 1024.0));
            buffer.append("M)!\n");
            buffer.append("\t\t=> -Xmx");
            buffer.append(floatFormat.format(512.0));
            buffer.append("M should have been specified.\n");
        }
    }

    public FullSourceWorkspaceCompleteSearchTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    protected void search(String patternString, int searchFor, int limitTo, JavaSearchResultCollector resultCollector) throws CoreException {
        int matchMode = patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1 ? 2 : 0;
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)(matchMode | 8));
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector, null);
    }

    protected void search(IJavaElement element, int limitTo, JavaSearchResultCollector resultCollector) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)limitTo, (int)8);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector, null);
    }

    protected void cleanCategoryTableCache(boolean type, JavaSearchResultCollector resultCollector) throws CoreException {
        long time = System.currentTimeMillis();
        if (type) {
            this.search("foo", 4, 0, resultCollector);
        } else {
            this.search("Foo", 0, 0, resultCollector);
        }
        if (DEBUG) {
            System.out.println("Time to clean category table cache: " + (System.currentTimeMillis() - time));
        }
    }

    public void testSearchStringTypeDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "Object";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 0, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for type '" + name + "' in workspace.");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(true, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 0, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringTypeReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "Object";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 0, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for type '" + name + "' in workspace.");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(true, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 0, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementTypeDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType type = object.getType();
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find type 'Object'", (type != null && type.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)type, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for type '" + type.getElementName() + "' in workspace.");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(true, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)type, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementTypeReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType type = object.getType();
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find type 'Object'", (type != null && type.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)type, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for type '" + type.getElementName() + "' in workspace.");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(true, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)type, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringFieldDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "name";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 4, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for field '" + name + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 4, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringFieldReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "name";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 4, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for field '" + name + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 4, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementFieldDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IType type = JDT_CORE_PROJECT.findType("org.eclipse.jdt.internal.core", "JavaElement");
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find compilation unit 'JavaElement.java' in 'org.eclipse.jdt.internal.core'", (type != null && type.exists() ? 1 : 0) != 0);
        IField field = type.getField("name");
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find field equals", (field != null && field.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)field, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for field '" + field.getElementName() + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)field, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementFieldReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IType type = JDT_CORE_PROJECT.findType("org.eclipse.jdt.internal.core", "JavaElement");
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find compilation unit 'JavaElement.java' in 'org.eclipse.jdt.internal.core'", (type != null && type.exists() ? 1 : 0) != 0);
        IField field = type.getField("name");
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find field equals", (field != null && field.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)field, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for field '" + field.getElementName() + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)field, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringMethodDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "equals";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 1, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for method '" + name + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 1, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringMethodReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "equals";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 1, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for method '" + name + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 1, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementMethodDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType objectType = object.getType();
        IMethod method = objectType.getMethod("equals", new String[]{"Ljava.lang.Object;"});
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find method equals", (method != null && method.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)method, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for method '" + method.getElementName() + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)method, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementMethodReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType objectType = object.getType();
        IMethod method = objectType.getMethod("equals", new String[]{"Ljava.lang.Object;"});
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find method equals", (method != null && method.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)method, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for method '" + method.getElementName() + "' in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)method, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringConstructorDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "()";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 3, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for default constructor in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 3, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchStringConstructorReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        String name = "()";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 3, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for default constructor in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search(name, 3, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementConstructorDeclarations() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType objectType = object.getType();
        IMethod constructor = objectType.getMethod("Object", new String[0]);
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find default constructor", (constructor != null && constructor.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)constructor, 0, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " declarations for default constructor in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)constructor, 0, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testSearchJavaElementConstructorReferences() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        IClassFile object = this.getClassFile(JDT_CORE_PROJECT, "rt.jar", "java.lang", "Object.class");
        IType objectType = object.getType();
        IMethod constructor = objectType.getMethod("Object", new String[0]);
        FullSourceWorkspaceCompleteSearchTests.assertTrue((String)"Cannot find default constructor", (constructor != null && constructor.exists() ? 1 : 0) != 0);
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search((IJavaElement)constructor, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.println("\t- " + intFormat.format(resultCollector.count) + " references for default constructor in workspace");
        int i = 0;
        while (i < 0) {
            this.cleanCategoryTableCache(false, resultCollector);
            this.runGc();
            this.startMeasuring();
            this.search((IJavaElement)constructor, 2, resultCollector);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    class JavaSearchResultCollector
    extends SearchRequestor {
        int count = 0;

        JavaSearchResultCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            ++this.count;
        }
    }

    class Measuring
    implements IJob {
        boolean start;

        Measuring(boolean start) {
            this.start = start;
        }

        public boolean belongsTo(String jobFamily) {
            return true;
        }

        public void cancel() {
        }

        public void ensureReadyToRun() {
        }

        public boolean execute(IProgressMonitor progress) {
            if (this.start) {
                FullSourceWorkspaceCompleteSearchTests.this.startMeasuring();
            } else {
                FullSourceWorkspaceCompleteSearchTests.this.stopMeasuring();
                FullSourceWorkspaceCompleteSearchTests.this.commitMeasurements();
                FullSourceWorkspaceCompleteSearchTests.this.assertPerformance();
            }
            return true;
        }

        public String getJobFamily() {
            return "FullSourceWorkspaceCompleteSearchTests.Measuring";
        }
    }
}

