/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.test.performance.PerformanceTestCase;

public class SecondaryTypesPerformanceTest
extends PerformanceTestCase {
    private static final String testScratchArea = String.valueOf(Util.getOutputDirectory()) + File.separator + "enumPerformanceTestScratchArea";
    private static final int numberOfClasspathsToCreate = 10;

    public static Test suite() {
        TestSuite suite = new TestSuite(SecondaryTypesPerformanceTest.class.getName());
        suite.addTestSuite(SecondaryTypesPerformanceTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        File testScratchAreaFile = new File(testScratchArea);
        if (!testScratchAreaFile.exists()) {
            testScratchAreaFile.mkdir();
            File packageFile = new File(testScratchAreaFile, "test" + File.separator + "performance");
            packageFile.mkdirs();
            this.writeDummySourceClasses(packageFile, "test.performance");
            Set<String> paths = this.createClasspathStrings();
            for (String path : paths) {
                File pathFile = new File(path);
                pathFile.mkdir();
                this.writeDummySourceClasses(pathFile, "test.performance." + pathFile.getName());
            }
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        File testScratchAreaFile = new File(testScratchArea);
        if (testScratchAreaFile.exists()) {
            Util.delete((File)testScratchAreaFile);
        }
    }

    public void test01() {
        ArrayList<String> classpathList = new ArrayList<String>();
        classpathList.addAll(this.createClasspathStrings());
        classpathList.add(testScratchArea);
        int i = 0;
        while (i < 10) {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setResolveBindings(true);
            parser.setStatementsRecovery(true);
            parser.setBindingsRecovery(true);
            parser.setCompilerOptions(this.createCompilerOptions());
            parser.setUnitName("X");
            parser.setKind(8);
            parser.setEnvironment(classpathList.toArray(new String[classpathList.size()]), null, null, true);
            parser.setSource("import test.performance.test1.*;\npublic enum X\n{\n    TEST;\n\n    public void method() {\n        new Z().toString();\n        new test.performance.test2.Z().toString();\n        new test.performance.test3.Z().toString();\n\n    }\n}".toCharArray());
            this.startMeasuring();
            ASTNode theAST = parser.createAST(null);
            theAST.accept(new ASTVisitor(){});
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private Map<String, String> createCompilerOptions() {
        HashMap<String, String> compilerOptions = new HashMap<String, String>(10);
        compilerOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        compilerOptions.put("org.eclipse.jdt.core.compiler.source", "1.8");
        compilerOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "HIGH");
        compilerOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        return compilerOptions;
    }

    private Set<String> createClasspathStrings() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>(10);
        int i = 1;
        while (i <= 10) {
            paths.add(String.valueOf(testScratchArea) + File.separator + "test" + File.separator + "performance" + File.separator + "test" + i);
            ++i;
        }
        return paths;
    }

    private void writeDummySourceClasses(File aPath, String packageName) throws IOException {
        this.writeFile(new File(aPath, "Z.java"), "public class Z {}");
        "ABC".toLowerCase(Locale.ENGLISH);
        int i = 1;
        while (i <= 100) {
            String sourceContent = "package " + packageName + ";\n" + "\n" + "import java.util.Locale;\n" + "\n" + "public class X" + i + " {\n" + "\tpublic X" + i + "() {\n" + "\t\t\"ABC\".toLowerCase(Locale.ENGLISH);\n" + "new Object() {\n" + "            @Override\n" + "            public String toString() {\n" + "                return \"Test\";\n" + "            }\n" + "        }.toString();" + "\t}\n" + "}";
            this.writeFile(new File(aPath, "X" + i + ".java"), sourceContent);
            ++i;
        }
    }

    private void writeFile(File aFile, String aSource) throws IOException {
        try (FileWriter fileWriter = new FileWriter(aFile);){
            fileWriter.write(aSource);
        }
    }
}

