/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance.util;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Report;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;

public class View {
    public static void main(String[] args) {
        Variations variations = PerformanceTestPlugin.getVariations();
        variations.put((Object)"config", (Object)"eclipseperflnx1_R3.3");
        variations.put((Object)"build", (Object)"I2007%");
        variations.put((Object)"jvm", (Object)"sun");
        String scenarioPattern = "%testFullBuildProject%";
        String seriesKey = "build";
        String outFile = null;
        if (args != null && args.length > 0) {
            outFile = args[0];
        }
        PrintStream ps = null;
        if (outFile != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("can't create output file");
            }
        }
        if (ps == null) {
            ps = System.out;
        }
        Scenario[] scenarios = DB.queryScenarios((Variations)variations, (String)scenarioPattern, (String)seriesKey, null);
        System.out.println(String.valueOf(scenarios.length) + " Scenarios");
        System.out.println();
        int s = 0;
        while (s < scenarios.length) {
            View.dump(ps, scenarios[s]);
            ++s;
        }
        if (ps != System.out) {
            ps.close();
        }
    }

    private static void dump(PrintStream ps, Scenario scenario) {
        System.out.print("Scenario: " + scenario.getScenarioName() + "...");
        ps.println("Scenario: " + scenario.getScenarioName());
        Report r = new Report(2);
        String[] timeSeriesLabels = scenario.getTimeSeriesLabels();
        r.addCell("build:");
        int j = 0;
        while (j < timeSeriesLabels.length) {
            r.addCellRight(timeSeriesLabels[j]);
            ++j;
        }
        r.nextRow();
        Dim[] dimensions = scenario.getDimensions();
        int i = 0;
        while (i < dimensions.length) {
            Dim dim = dimensions[i];
            String dimName = dim.getName();
            if (dimName.equals("CPU Time") || dimName.equals("Elapsed Process") || dimName.equals("Used Java Heap")) {
                r.addCell(String.valueOf(dimName) + ':');
                TimeSeries ts = scenario.getTimeSeries(dim);
                int n = ts.getLength();
                int j2 = 0;
                while (j2 < n) {
                    String stddev = "";
                    double stddev2 = ts.getStddev(j2);
                    if (stddev2 != 0.0) {
                        stddev = " [" + dim.getDisplayValue(stddev2) + "]";
                    }
                    r.addCellRight(String.valueOf(dim.getDisplayValue(ts.getValue(j2))) + stddev);
                    ++j2;
                }
                r.nextRow();
            }
            ++i;
        }
        r.print(ps);
        ps.println();
        System.out.println("done");
    }
}

