/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.Region;

public class RegionPerformanceTests
extends TestCase {
    protected IProject project;
    private TestingEnvironment env = null;

    public RegionPerformanceTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(RegionPerformanceTests.class);
    }

    protected IJavaProject createJavaProject(String projectName) throws Exception {
        IPath projectPath = this.env.addProject(projectName, "1.8");
        this.env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.env.removePackageFragmentRoot(projectPath, "");
        this.env.addPackageFragmentRoot(projectPath, "src");
        this.env.setOutputFolder(projectPath, "bin");
        IJavaProject javaProj = this.env.getJavaProject(projectPath);
        return javaProj;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.env == null) {
            this.env = new TestingEnvironment();
            this.env.openEmptyWorkspace();
        }
        this.env.resetWorkspace();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.env.resetWorkspace();
        JavaCore.setOptions((Hashtable)JavaCore.getDefaultOptions());
    }

    public void testRegion() throws Exception {
        IJavaProject jproj = this.createJavaProject("RegionTest");
        IProject proj = jproj.getProject();
        IPath projPath = proj.getFullPath();
        IPath root = projPath.append("src");
        int idx = 0;
        while (idx < 1000) {
            this.env.addClass(root, "test", "Foo" + idx, "package test;\n\npublic class Foo" + idx + " {\n" + "}");
            ++idx;
        }
        this.env.fullBuild();
        idx = 0;
        while (idx < 10) {
            IPackageFragment[] fragments;
            this.startMeasuring();
            Region region = new Region();
            IPackageFragment[] iPackageFragmentArray = fragments = jproj.getPackageFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement[] children;
                IPackageFragment next = iPackageFragmentArray[n2];
                IJavaElement[] iJavaElementArray = children = next.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement nextChild = iJavaElementArray[n4];
                    region.add(nextChild);
                    ++n4;
                }
                ++n2;
            }
            this.stopMeasuring();
            ++idx;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

