/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.classpath;

import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathGroup;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathMessages;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;

public class DependencyModel
extends ClasspathModel {
    public static final int MODULE_PATH = 0;
    public static final int CLASS_PATH = 1;
    private ClasspathGroup modulepathEntries;
    private ClasspathGroup classpathEntries;

    @Override
    public Object addEntry(int entryType, IRuntimeClasspathEntry entry) {
        IClasspathEntry entryParent = null;
        switch (entryType) {
            case 0: {
                entryParent = this.getModulepathEntry();
                break;
            }
            case 1: {
                entryParent = this.getClasspathEntry();
                break;
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        for (Object element : this.childEntries) {
            if (!(element instanceof ClasspathGroup ? ((ClasspathGroup)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            ((ClasspathGroup)entryParent).addEntry(newEntry, null);
        } else {
            this.childEntries.add(newEntry);
        }
        return newEntry;
    }

    @Override
    public IClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.modulepathEntries == null) break;
                return this.modulepathEntries.getEntries();
            }
            case 1: {
                if (this.classpathEntries == null) break;
                return this.classpathEntries.getEntries();
            }
        }
        return new IClasspathEntry[0];
    }

    @Override
    public IRuntimeClasspathEntry[] getAllEntries() {
        IClasspathEntry[] boot = this.getEntries(0);
        IClasspathEntry[] user = this.getEntries(1);
        IRuntimeClasspathEntry[] all = new IRuntimeClasspathEntry[boot.length + user.length];
        if (boot.length > 0) {
            System.arraycopy(boot, 0, all, 0, boot.length);
        }
        if (user.length > 0) {
            System.arraycopy(user, 0, all, boot.length, user.length);
        }
        return all;
    }

    @Override
    public void removeAll() {
        if (this.modulepathEntries != null) {
            this.modulepathEntries.removeAll();
        }
        if (this.classpathEntries != null) {
            this.classpathEntries.removeAll();
        }
    }

    public IClasspathEntry getModulepathEntry() {
        if (this.modulepathEntries == null) {
            String name = ClasspathMessages.DependencyModel_0;
            this.modulepathEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.modulepathEntries;
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.classpathEntries == null) {
            String name = ClasspathMessages.DependencyModel_1;
            this.classpathEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.classpathEntries;
    }

    @Override
    public void createEntries() {
        this.getModulepathEntry();
        this.getClasspathEntry();
    }
}

