/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnpackFatJarAntExporter
extends FatJarAntExporter {
    public UnpackFatJarAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        super(antScriptLocation, jarLocation, launchConfiguration);
    }

    @Override
    protected void buildANTScript(IPath antScriptLocation, String projectName, IPath absJarfile, String mainClass, FatJarAntExporter.SourceInfo[] sourceInfos) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(antScriptLocation.toFile());
            String absJarname = absJarfile.toString();
            DocumentBuilder docBuilder = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotGetXmlBuilder);
            }
            Document document = docBuilder.newDocument();
            Element project = document.createElement("project");
            project.setAttribute("name", "Create Runnable Jar for Project " + projectName);
            project.setAttribute("default", "create_run_jar");
            document.appendChild(project);
            Comment comment = document.createComment("this file was created by Eclipse Runnable JAR Export Wizard");
            project.appendChild(comment);
            comment = document.createComment("ANT 1.7 is required                                        ");
            project.appendChild(comment);
            this.addBaseDirProperties(document, project);
            Element target = document.createElement("target");
            target.setAttribute("name", "create_run_jar");
            project.appendChild(target);
            Element jar = document.createElement("jar");
            jar.setAttribute("destfile", this.substituteBaseDirs(absJarname));
            jar.setAttribute("filesetmanifest", "mergewithoutmain");
            target.appendChild(jar);
            Element manifest = document.createElement("manifest");
            jar.appendChild(manifest);
            Element attribute = document.createElement("attribute");
            attribute.setAttribute("name", "Main-Class");
            attribute.setAttribute("value", mainClass);
            manifest.appendChild(attribute);
            attribute = document.createElement("attribute");
            attribute.setAttribute("name", "Class-Path");
            attribute.setAttribute("value", ".");
            manifest.appendChild(attribute);
            int i = 0;
            while (i < sourceInfos.length) {
                FatJarAntExporter.SourceInfo sourceInfo = sourceInfos[i];
                if (sourceInfo.isJar) {
                    Element zipfileset = document.createElement("zipfileset");
                    zipfileset.setAttribute("src", this.substituteBaseDirs(sourceInfo.absPath));
                    zipfileset.setAttribute("excludes", "META-INF/*.SF");
                    jar.appendChild(zipfileset);
                } else {
                    Element fileset = document.createElement("fileset");
                    fileset.setAttribute("dir", this.substituteBaseDirs(sourceInfo.absPath));
                    jar.appendChild(fileset);
                }
                ++i;
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outputStream);
                transformer.transform(source, result);
            }
            catch (TransformerException transformerException) {
                throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotTransformToXML);
            }
        }
    }
}

