/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class MutableObservableCollectionContractTest
extends ObservableDelegateTest {
    private IObservableCollectionContractDelegate delegate;
    private IObservableCollection collection;

    public MutableObservableCollectionContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public MutableObservableCollectionContractTest(String name, IObservableCollectionContractDelegate delegate) {
        super(name, delegate);
        this.delegate = delegate;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.collection = (IObservableCollection)super.getObservable();
    }

    public void testAdd_ChangeEvent() throws Exception {
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.add(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection));
            }
        }, "Collection.add(Object)", this.collection);
    }

    public void testAdd_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.add(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testAdd_ChangeEventFiredAfterElementIsAdded() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.assertContainsDuringChangeEvent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.add(element);
            }
        }, "Collection.add(Object)", this.collection, element);
    }

    public void testAddAll_ChangeEvent() throws Exception {
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.addAll(Arrays.asList(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection)));
            }
        }, "Collection.addAll(Collection)", this.collection);
    }

    public void testAddAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.addAll(Arrays.asList(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection)));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testAddAll_ChangeEventFiredAfterElementsAreAdded() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.assertContainsDuringChangeEvent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.addAll(Arrays.asList(element));
            }
        }, "Collection.addAll(Collection)", this.collection, element);
    }

    public void testRemove_ChangeEvent() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.remove(element);
            }
        }, "Collection.remove(Object)", this.collection);
    }

    public void testRemove_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.remove(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testRemove_ChangeEventFiredAfterElementIsRemoved() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.remove(element);
            }
        }, "Collection.remove(Object)", this.collection, element);
    }

    public void testRemoveAll_ChangeEvent() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.removeAll(Arrays.asList(element));
            }
        }, "Collection.removeAll(Collection)", this.collection);
    }

    public void testRemoveAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.removeAll(Arrays.asList(MutableObservableCollectionContractTest.this.delegate.createElement(MutableObservableCollectionContractTest.this.collection)));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testRemoveAll_ChangeEventFiredAfterElementsAreRemoved() throws Exception {
        final Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.removeAll(Arrays.asList(element));
            }
        }, "Collection.removeAll(Collection)", this.collection, element);
    }

    public void testRemoveAll_NoChange() throws Exception {
        ChangeEventTracker tracker = ChangeEventTracker.observe((IObservable)this.collection);
        this.collection.removeAll((Collection)Collections.EMPTY_LIST);
        MutableObservableCollectionContractTest.assertEquals((String)"List.removeAll on an empty list should not fire a list change event", (int)0, (int)tracker.count);
    }

    public void testRetainAll_ChangeEvent() throws Exception {
        final Object element1 = this.delegate.createElement(this.collection);
        this.collection.add(element1);
        Object element2 = this.delegate.createElement(this.collection);
        this.collection.add(element2);
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.retainAll(Arrays.asList(element1));
            }
        }, "Collection.retainAll(Collection)", this.collection);
    }

    public void testRetainAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.retainAll((Collection)Collections.EMPTY_LIST);
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testRetainAll_ChangeEventFiredAfterElementsAreRetained() throws Exception {
        Object element1 = this.delegate.createElement(this.collection);
        this.collection.add(element1);
        Object element2 = this.delegate.createElement(this.collection);
        this.collection.add(element2);
        MutableObservableCollectionContractTest.assertTrue((boolean)this.collection.contains(element1));
        MutableObservableCollectionContractTest.assertTrue((boolean)this.collection.contains(element2));
        ContainsListener listener1 = new ContainsListener(this.collection, element1).init();
        ContainsListener listener2 = new ContainsListener(this.collection, element2).init();
        listener1.contains = false;
        listener2.contains = true;
        this.collection.retainAll(Arrays.asList(element1));
        MutableObservableCollectionContractTest.assertTrue((String)this.formatFail("When Collection.retainAll(...) fires the change event the element should have been retained in the Collection."), (boolean)listener1.contains);
        MutableObservableCollectionContractTest.assertFalse((String)this.formatFail("When Collection.retainAll(...) fires the change event the element should have been removed from the Collection."), (boolean)listener2.contains);
    }

    public void testRetainAll_NoChangeFiresNoChangeEvent() throws Exception {
        ChangeEventTracker tracker = ChangeEventTracker.observe((IObservable)this.collection);
        this.collection.retainAll((Collection)Collections.EMPTY_LIST);
        MutableObservableCollectionContractTest.assertEquals((String)"List.retainAll should not have fired a change event:", (int)0, (int)tracker.count);
    }

    public void testClear_ChangeEvent() throws Exception {
        this.collection.add(this.delegate.createElement(this.collection));
        this.assertChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.clear();
            }
        }, "List.clear()", this.collection);
    }

    public void testClear_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.clear();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testClear_ChangeEventFiredAfterElementIsRemoved() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(new Runnable(){

            @Override
            public void run() {
                MutableObservableCollectionContractTest.this.collection.clear();
            }
        }, "List.clear()", this.collection, element);
    }

    void assertChangeEventFired(Runnable runnable, String methodName, IObservableCollection collection) {
        ChangeEventTracker listener = ChangeEventTracker.observe((IObservable)collection);
        runnable.run();
        MutableObservableCollectionContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should fire one ChangeEvent."), (int)1, (int)listener.count);
        MutableObservableCollectionContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + "'s change event observable should be the created Collection."), (Object)collection, (Object)listener.event.getObservable());
    }

    void assertDoesNotContainDuringChangeEvent(Runnable runnable, String methodName, IObservableCollection collection, Object elementNotContained) {
        MutableObservableCollectionContractTest.assertTrue((boolean)collection.contains(elementNotContained));
        ContainsListener listener = new ContainsListener(collection, elementNotContained).init();
        listener.contains = true;
        collection.remove(elementNotContained);
        MutableObservableCollectionContractTest.assertFalse((String)this.formatFail(new StringBuffer("When ").append(methodName).append(" fires a change event the element should have been removed from the Collection.").toString()), (boolean)listener.contains);
    }

    void assertContainsDuringChangeEvent(Runnable runnable, String methodName, IObservableCollection collection, Object elementContained) {
        ContainsListener listener = new ContainsListener(collection, elementContained).init();
        MutableObservableCollectionContractTest.assertFalse((boolean)collection.contains(elementContained));
        runnable.run();
        MutableObservableCollectionContractTest.assertTrue((String)this.formatFail(new StringBuffer("When ").append(methodName).append(" fires a change event the element should have been added to the Collection.").toString()), (boolean)listener.contains);
    }

    public static Test suite(IObservableCollectionContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(MutableObservableCollectionContractTest.class, delegate).addObservableContractTest(ObservableCollectionContractTest.class, delegate).build();
    }

    static class ContainsListener
    implements IChangeListener {
        boolean contains;
        private final Object element;
        private final IObservableCollection collection;

        ContainsListener(IObservableCollection collection, Object element) {
            this.element = element;
            this.collection = collection;
        }

        ContainsListener init() {
            this.collection.addChangeListener((IChangeListener)this);
            return this;
        }

        public void handleChange(ChangeEvent event) {
            this.contains = this.collection.contains(this.element);
        }
    }
}

