/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import junit.framework.Test;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.jface.databinding.conformance.MutableObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class MutableObservableSetContractTest
extends MutableObservableCollectionContractTest {
    private IObservableCollectionContractDelegate delegate;
    private IObservableSet set;

    public MutableObservableSetContractTest(String testName, IObservableCollectionContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    public MutableObservableSetContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.set = (IObservableSet)this.getObservable();
    }

    public void testAdd_SetChangeEvent() throws Exception {
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.add(MutableObservableSetContractTest.this.delegate.createElement((IObservableCollection)MutableObservableSetContractTest.this.set));
            }
        }, "Set.add(Object)", this.set);
    }

    public void testAdd_SetDiffEntry() throws Exception {
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.assertAddDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.add(element);
            }
        }, "Set.add(Object)", this.set, element);
    }

    public void testAdd_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.add(MutableObservableSetContractTest.this.delegate.createElement((IObservableCollection)MutableObservableSetContractTest.this.set));
            }
        }, "Set.add(Object)", (IObservable)this.set);
    }

    public void testAddAll_SetChangeEvent() throws Exception {
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.addAll(Arrays.asList(MutableObservableSetContractTest.this.delegate.createElement((IObservableCollection)MutableObservableSetContractTest.this.set)));
            }
        }, "Set.addAll(Collection", this.set);
    }

    public void testAddAll_SetDiffEntry() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.assertAddDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.addAll(Arrays.asList(element));
            }
        }, "Set.addAll(Collection)", this.set, element);
    }

    public void testAddAll_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.addAll(Collections.singleton(MutableObservableSetContractTest.this.delegate.createElement((IObservableCollection)MutableObservableSetContractTest.this.set)));
            }
        }, "Set.addAll(Collection)", (IObservable)this.set);
    }

    public void testRemove_SetChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.remove(element);
            }
        }, "Set.remove(Object)", this.set);
    }

    public void testRemove_SetDiffEntry() throws Exception {
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.remove(element);
            }
        }, "Set.remove(Object)", this.set, element);
    }

    public void testRemove_GetterCalled() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.remove(element);
            }
        }, "Set.remove(Object)", (IObservable)this.set);
    }

    public void testRemoveAll_SetChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.removeAll(Arrays.asList(element));
            }
        }, "Set.removeAll(Collection)", this.set);
    }

    public void testRemoveAll_SetDiffEntry() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.removeAll(Arrays.asList(element));
            }
        }, "Set.removeAll(Collection)", this.set, element);
    }

    public void testRemoveAll_GetterCalled() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.removeAll(Collections.singleton(element));
            }
        }, "Set.removeAll(Collection)", (IObservable)this.set);
    }

    public void testRetainAll_SetChangeEvent() throws Exception {
        final Object element1 = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element1);
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.retainAll(Arrays.asList(element1));
            }
        }, "Set.retainAll(Collection", this.set);
    }

    public void testRetainAll_SetDiffEntry() throws Exception {
        final Object element1 = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element1);
        Object element2 = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element2);
        this.assertRemoveDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.retainAll(Arrays.asList(element1));
            }
        }, "Set.retainAll(Collection)", this.set, element2);
    }

    public void testRetainAll_GetterCalled() throws Exception {
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.retainAll((Collection)Collections.EMPTY_SET);
            }
        }, "Set.retainAll(Collection)", (IObservable)this.set);
    }

    public void testClear_SetChangeEvent() throws Exception {
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        this.assertSetChangeEventFired(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.clear();
            }
        }, "Set.clear()", this.set);
    }

    public void testClear_SetDiffEntry() throws Exception {
        Object element = this.delegate.createElement((IObservableCollection)this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.clear();
            }
        }, "Set.clear()", this.set, element);
    }

    public void testClear_GetterCalled() throws Exception {
        this.set.add(this.delegate.createElement((IObservableCollection)this.set));
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                MutableObservableSetContractTest.this.set.clear();
            }
        }, "Set.clear()", (IObservable)this.set);
    }

    private void assertSetChangeEventFired(Runnable runnable, String methodName, IObservableSet set) {
        ArrayList<IObservablesListener> queue = new ArrayList<IObservablesListener>();
        SetChangeEventTracker setListener = new SetChangeEventTracker(queue);
        ChangeEventTracker changeListener = new ChangeEventTracker(queue);
        set.addSetChangeListener((ISetChangeListener)setListener);
        set.addChangeListener((IChangeListener)changeListener);
        runnable.run();
        MutableObservableSetContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should fire one SetChangeEvent."), (int)1, (int)setListener.count);
        MutableObservableSetContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + "'s change event observable should be the created Set."), (Object)set, (Object)setListener.event.getObservable());
        MutableObservableSetContractTest.assertEquals((String)this.formatFail("Two notifications should have been received."), (int)2, (int)queue.size());
        MutableObservableSetContractTest.assertEquals((String)this.formatFail("ChangeEvent of " + methodName + " should have fired before the SetChangeEvent."), (Object)changeListener, queue.get(0));
        MutableObservableSetContractTest.assertEquals((String)this.formatFail("SetChangeEvent of " + methodName + " should have fired after the ChangeEvent."), (Object)setListener, queue.get(1));
    }

    private void assertAddDiffEntry(Runnable runnable, String methodName, IObservableSet set, Object element) {
        SetChangeEventTracker listener = new SetChangeEventTracker();
        set.addSetChangeListener((ISetChangeListener)listener);
        runnable.run();
        Set entries = listener.event.diff.getAdditions();
        MutableObservableSetContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should result in one diff entry."), (int)1, (int)entries.size());
        MutableObservableSetContractTest.assertTrue((String)this.formatFail(String.valueOf(methodName) + " should result in a diff entry that is an addition."), (boolean)entries.contains(element));
    }

    private void assertRemoveDiffEntry(Runnable runnable, String methodName, IObservableSet set, Object element) {
        SetChangeEventTracker listener = new SetChangeEventTracker();
        set.addSetChangeListener((ISetChangeListener)listener);
        runnable.run();
        Set entries = listener.event.diff.getRemovals();
        MutableObservableSetContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should result in one diff entry."), (int)1, (int)entries.size());
        MutableObservableSetContractTest.assertTrue((String)this.formatFail(String.valueOf(methodName) + " should result in a diff entry that is a removal."), (boolean)entries.contains(element));
    }

    public static Test suite(IObservableCollectionContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(MutableObservableSetContractTest.class, delegate).addObservableContractTest(ObservableCollectionContractTest.class, delegate).build();
    }
}

