/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import junit.framework.Test;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;

public class MutableObservableValueContractTest
extends ObservableDelegateTest {
    private IObservableValueContractDelegate delegate;
    private IObservableValue observable;

    public MutableObservableValueContractTest(IObservableValueContractDelegate delegate) {
        this(null, delegate);
    }

    public MutableObservableValueContractTest(String testName, IObservableValueContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
    }

    public void testSetValue_SetsValue() throws Exception {
        Object value = this.delegate.createValue(this.observable);
        this.observable.setValue(value);
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("IObservableValue.setValue(Object) should set the value of the observable."), (Object)value, (Object)this.observable.getValue());
    }

    public void testSetValue_ChangeEvent() throws Exception {
        ChangeEventTracker listener = ChangeEventTracker.observe((IObservable)this.observable);
        this.observable.setValue(this.delegate.createValue(this.observable));
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("Change event listeners were not notified"), (int)1, (int)listener.count);
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("IObservableValue.setValue(Object) should fire one ChangeEvent."), (int)1, (int)listener.count);
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("IObservableValue.setValue(Object)'s change event observable should be the created observable."), (Object)this.observable, (Object)listener.event.getObservable());
    }

    public void testSetValue_SameValue() throws Exception {
        this.delegate.change((IObservable)this.observable);
        ValueChangeEventTracker valueChangeListener = ValueChangeEventTracker.observe(this.observable);
        ChangeEventTracker changeListener = ChangeEventTracker.observe((IObservable)this.observable);
        Object value = this.observable.getValue();
        this.observable.setValue(value);
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("IObservableValue.setValue() should not fire a value change event when the value has not change."), (int)0, (int)valueChangeListener.count);
        MutableObservableValueContractTest.assertEquals((String)this.formatFail("IObservableValue.setValue() should not fire a change event when the value has not change."), (int)0, (int)changeListener.count);
    }

    public void testSetValue_RealmChecks() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                MutableObservableValueContractTest.this.observable.setValue(MutableObservableValueContractTest.this.delegate.createValue(MutableObservableValueContractTest.this.observable));
            }
        }, (CurrentRealm)this.observable.getRealm());
    }

    public static Test suite(IObservableValueContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(MutableObservableValueContractTest.class, delegate).addObservableContractTest(ObservableValueContractTest.class, delegate).build();
    }
}

