/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.Arrays;
import junit.framework.Test;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class ObservableCollectionContractTest
extends ObservableContractTest {
    private IObservableCollectionContractDelegate delegate;
    private IObservableCollection collection;

    public ObservableCollectionContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public ObservableCollectionContractTest(String testName, IObservableCollectionContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.collection = (IObservableCollection)this.getObservable();
    }

    public void testIterator_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.iterator();
            }
        }, "Collection.iterator()", (IObservable)this.collection);
    }

    public void testIterator_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.iterator();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testSize_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.size();
            }
        }, "Collection.size()", (IObservable)this.collection);
    }

    public void testSize_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.size();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testIsEmpty_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.isEmpty();
            }
        }, "Collection.isEmpty()", (IObservable)this.collection);
    }

    public void testIsEmpty_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.isEmpty();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testContains_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.contains(ObservableCollectionContractTest.this.delegate.createElement(ObservableCollectionContractTest.this.collection));
            }
        }, "Collection.contains(...)", (IObservable)this.collection);
    }

    public void testContains_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.contains(ObservableCollectionContractTest.this.delegate.createElement(ObservableCollectionContractTest.this.collection));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testContainsAll_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.containsAll(Arrays.asList(ObservableCollectionContractTest.this.delegate.createElement(ObservableCollectionContractTest.this.collection)));
            }
        }, "Collection.containsAll(Collection)", (IObservable)this.collection);
    }

    public void testContainsAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.containsAll(Arrays.asList(ObservableCollectionContractTest.this.delegate.createElement(ObservableCollectionContractTest.this.collection)));
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testToArray_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.toArray();
            }
        }, "Collection.toArray()", (IObservable)this.collection);
    }

    public void testToArray_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.toArray();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testToArrayWithObjectArray_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.toArray(new Object[ObservableCollectionContractTest.this.collection.size()]);
            }
        }, "Collection.toArray(Object[])", (IObservable)this.collection);
    }

    public void testToArrayWithObjectArray_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.toArray(new Object[ObservableCollectionContractTest.this.collection.size()]);
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testEquals_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.equals((Object)ObservableCollectionContractTest.this.collection);
            }
        }, "Collection.equals(Object)", (IObservable)this.collection);
    }

    public void testEquals_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.equals((Object)ObservableCollectionContractTest.this.collection);
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testEquals_IdentityEquals() throws Exception {
        ObservableCollectionContractTest.assertTrue((boolean)this.collection.equals((Object)this.collection));
    }

    public void testHashCode_GetterCalled() throws Exception {
        this.assertGetterCalled(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.hashCode();
            }
        }, "Collection.hashCode()", (IObservable)this.collection);
    }

    public void testHashCode_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(new Runnable(){

            @Override
            public void run() {
                ObservableCollectionContractTest.this.collection.hashCode();
            }
        }, (CurrentRealm)this.collection.getRealm());
    }

    public void testGetElementType_ReturnsType() throws Exception {
        ObservableCollectionContractTest.assertEquals((String)"Element type of the collection should be returned from IObservableCollection.getElementType()", (Object)this.delegate.getElementType(this.collection), (Object)this.collection.getElementType());
    }

    public static Test suite(IObservableCollectionContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(ObservableCollectionContractTest.class, delegate).build();
    }
}

