/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import junit.framework.Test;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class ObservableStaleContractTest
extends ObservableDelegateTest {
    private IObservableContractDelegate delegate;
    private IObservable observable;

    public ObservableStaleContractTest(IObservableContractDelegate delegate) {
        this(null, delegate);
    }

    public ObservableStaleContractTest(String testName, IObservableContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.observable = this.getObservable();
    }

    public void testIsStale_TrueWhenStale() throws Exception {
        this.delegate.setStale(this.observable, true);
        ObservableStaleContractTest.assertTrue((String)this.formatFail("When stale isStale() should return true."), (boolean)this.observable.isStale());
    }

    public void testIsStale_FalseWhenNotStale() throws Exception {
        this.delegate.setStale(this.observable, false);
        ObservableStaleContractTest.assertFalse((String)this.formatFail("When not stale isStale() should return false."), (boolean)this.observable.isStale());
    }

    public void testBecomingStaleFiresStaleEvent() throws Exception {
        StaleListener listener = new StaleListener();
        this.ensureStale(this.observable, false);
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        ObservableStaleContractTest.assertEquals((String)this.formatFail("When becoming stale listeners should be notified."), (int)1, (int)listener.count);
    }

    public void testStaleEventObservable() throws Exception {
        StaleListener listener = new StaleListener();
        this.ensureStale(this.observable, false);
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        StaleEvent event = listener.event;
        ObservableStaleContractTest.assertNotNull((String)this.formatFail("stale event was null"), (Object)event);
        ObservableStaleContractTest.assertEquals((String)this.formatFail("When notifying listeners of becoming stale the observable should be the source of the event."), (Object)this.observable, (Object)event.getObservable());
    }

    public void testRemoveStaleListener_RemovesListener() throws Exception {
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.ensureStale(this.observable, false);
        this.delegate.setStale(this.observable, true);
        ObservableStaleContractTest.assertEquals((String)this.formatFail("set stale did not notify listeners"), (int)1, (int)listener.count);
        this.observable.removeStaleListener((IStaleListener)listener);
        this.ensureStale(this.observable, false);
        this.delegate.setStale(this.observable, true);
        ObservableStaleContractTest.assertEquals((String)this.formatFail("Once removed stale listeners should not be notified of becoming stale."), (int)1, (int)listener.count);
    }

    public void testStaleListenersAreNotNotifiedWhenObservableIsNoLongerStale() throws Exception {
        this.ensureStale(this.observable, true);
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, false);
        ObservableStaleContractTest.assertEquals((String)this.formatFail("Stale listeners should not be notified when the stale state changes from true to false."), (int)0, (int)listener.count);
    }

    public void testObservableRealmIsCurrentOnStale() throws Exception {
        this.ensureStale(this.observable, false);
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        ObservableStaleContractTest.assertTrue((String)this.formatFail("When notifying listeners of becoming stale the observable's realm should be the current realm."), (boolean)listener.isCurrentRealm);
    }

    private void ensureStale(IObservable observable, boolean stale) {
        if (observable.isStale() != stale) {
            this.delegate.setStale(observable, stale);
        }
        ObservableStaleContractTest.assertEquals((boolean)stale, (boolean)observable.isStale());
    }

    public static Test suite(IObservableContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(ObservableStaleContractTest.class, delegate).build();
    }

    static class StaleListener
    implements IStaleListener {
        int count;
        StaleEvent event;
        boolean isCurrentRealm;

        StaleListener() {
        }

        public void handleStale(StaleEvent staleEvent) {
            ++this.count;
            this.event = staleEvent;
            this.isCurrentRealm = staleEvent.getObservable().getRealm().isCurrent();
        }
    }
}

