/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BindingTest
extends AbstractDefaultRealmTestCase {
    private IObservable target;
    private IObservable model;
    private DataBindingContext dbc;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.target = WritableValue.withValueType(String.class);
        this.model = WritableValue.withValueType(String.class);
        this.dbc = new DataBindingContext();
    }

    public void testDisposeTargetDisposesBinding() {
        Binding binding = this.createBinding();
        BindingTest.assertFalse((boolean)binding.isDisposed());
        this.target.dispose();
        BindingTest.assertTrue((boolean)binding.isDisposed());
    }

    public void testDisposeModelDisposesBinding() {
        Binding binding = this.createBinding();
        BindingTest.assertFalse((boolean)binding.isDisposed());
        this.model.dispose();
        BindingTest.assertTrue((boolean)binding.isDisposed());
    }

    public void testPreDisposedTarget_FiresIllegalArgumentException() {
        try {
            this.target.dispose();
            this.createBinding();
            BindingTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testPreDisposedModel_FiresIllegalArgumentException() {
        try {
            this.model.dispose();
            this.createBinding();
            BindingTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testDisposeModelThenBinding() {
        Binding binding = this.createBinding();
        this.model.dispose();
        binding.dispose();
    }

    public void testDisposeTargetThenBinding() {
        Binding binding = this.createBinding();
        this.target.dispose();
        binding.dispose();
    }

    public void testDisposeObservablesThenBinding() {
        Binding binding = this.createBinding();
        this.model.dispose();
        this.target.dispose();
        binding.dispose();
    }

    public void testDisposeBindingThenModel() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.model.dispose();
    }

    public void testDisposeBindingThenTarget() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.target.dispose();
    }

    public void testDisposeBindingThenObservables() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    private Binding createBinding() {
        BindingStub binding = new BindingStub(this.target, this.model);
        binding.init(this.dbc);
        return binding;
    }

    private static class BindingStub
    extends Binding {
        BindingStub(IObservable target, IObservable model) {
            super(target, model);
        }

        public IObservableValue getValidationStatus() {
            return null;
        }

        protected void postInit() {
        }

        protected void preInit() {
        }

        public void updateModelToTarget() {
        }

        public void updateTargetToModel() {
        }

        public void validateModelToTarget() {
        }

        public void validateTargetToModel() {
        }
    }
}

