/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DatabindingContextTest
extends AbstractDefaultRealmTestCase {
    private DataBindingContext dbc;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dbc = new DataBindingContext();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.tearDown();
    }

    public void testDisposeBindings() throws Exception {
        BindingStub binding = new BindingStub();
        binding.init(this.dbc);
        DatabindingContextTest.assertFalse((boolean)binding.isDisposed());
        this.dbc.dispose();
        DatabindingContextTest.assertTrue((String)"binding should be diposed when dbc is disposed", (boolean)binding.isDisposed());
    }

    public void testBindValue() throws Exception {
        WritableValue target = WritableValue.withValueType(String.class);
        WritableValue model = WritableValue.withValueType(String.class);
        Binding binding = this.dbc.bindValue((IObservableValue)target, (IObservableValue)model);
        DatabindingContextTest.assertTrue((String)"binding is of the incorrect type", (boolean)binding.getClass().getName().endsWith("ValueBinding"));
    }

    public void testBindList() throws Exception {
        WritableList target = WritableList.withElementType(Object.class);
        WritableList model = WritableList.withElementType(Object.class);
        Binding binding = this.dbc.bindList((IObservableList)target, (IObservableList)model);
        DatabindingContextTest.assertTrue((String)"binding is of the incorrect type", (boolean)binding.getClass().getName().endsWith("ListBinding"));
    }

    public void testValidationError() throws Exception {
        WritableValue targetObservable = WritableValue.withValueType(String.class);
        WritableValue modelObservable = WritableValue.withValueType(String.class);
        ValueChangeEventTracker errorCounter = new ValueChangeEventTracker();
        ChangeEventTracker errorsCounter = new ChangeEventTracker();
        AggregateValidationStatus error = new AggregateValidationStatus((IObservableCollection)this.dbc.getBindings(), 2);
        error.addValueChangeListener((IValueChangeListener)errorCounter);
        DatabindingContextTest.assertTrue((boolean)((IStatus)error.getValue()).isOK());
        IObservableMap errors = this.dbc.getValidationStatusMap();
        errors.addChangeListener((IChangeListener)errorsCounter);
        DatabindingContextTest.assertEquals((int)0, (int)errors.size());
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                return ValidationStatus.error((String)"error");
            }
        };
        this.dbc.bindValue((IObservableValue)targetObservable, (IObservableValue)modelObservable, new UpdateValueStrategy().setAfterGetValidator(validator), null);
        targetObservable.setValue((Object)"");
        DatabindingContextTest.assertFalse((boolean)((IStatus)error.getValue()).isOK());
        DatabindingContextTest.assertEquals((String)"error", (String)((IStatus)error.getValue()).getMessage());
        DatabindingContextTest.assertEquals((int)1, (int)errors.size());
        DatabindingContextTest.assertEquals((int)1, (int)errorsCounter.count);
        DatabindingContextTest.assertEquals((int)1, (int)errorCounter.count);
        error.dispose();
    }

    public void testBindValueAddBinding() throws Exception {
        WritableValue targetValue = WritableValue.withValueType(String.class);
        WritableValue modelValue = WritableValue.withValueType(String.class);
        DatabindingContextTest.assertNotNull((Object)this.dbc.getBindings());
        DatabindingContextTest.assertEquals((int)0, (int)this.dbc.getBindings().size());
        Binding binding = this.dbc.bindValue((IObservableValue)targetValue, (IObservableValue)modelValue);
        DatabindingContextTest.assertNotNull((Object)binding);
        DatabindingContextTest.assertNotNull((Object)this.dbc.getBindings());
        DatabindingContextTest.assertEquals((int)1, (int)this.dbc.getBindings().size());
        DatabindingContextTest.assertEquals((Object)binding, (Object)this.dbc.getBindings().get(0));
    }

    public void testBindListAddBinding() throws Exception {
        WritableList targetList = new WritableList(new ArrayList(), Object.class);
        WritableList modelList = new WritableList(new ArrayList(), Object.class);
        DatabindingContextTest.assertNotNull((Object)this.dbc.getBindings());
        DatabindingContextTest.assertEquals((int)0, (int)this.dbc.getBindings().size());
        Binding binding = this.dbc.bindList((IObservableList)targetList, (IObservableList)modelList);
        DatabindingContextTest.assertNotNull((Object)binding);
        DatabindingContextTest.assertNotNull((Object)this.dbc.getBindings());
        DatabindingContextTest.assertEquals((int)1, (int)this.dbc.getBindings().size());
        DatabindingContextTest.assertEquals((Object)binding, (Object)this.dbc.getBindings().get(0));
    }

    public void testGetBindingsImmutability() throws Exception {
        BindingStub binding = new BindingStub();
        binding.init(this.dbc);
        try {
            this.dbc.getBindings().remove(0);
            DatabindingContextTest.fail((String)"exception should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveBinding() throws Exception {
        BindingStub binding = new BindingStub();
        binding.init(this.dbc);
        DatabindingContextTest.assertTrue((String)"context should contain the binding", (boolean)this.dbc.getBindings().contains((Object)binding));
        binding.dispose();
        DatabindingContextTest.assertFalse((String)"binding should have been removed", (boolean)this.dbc.getBindings().contains((Object)binding));
    }

    public void testValidateTargetAfterValueBindingCreation() throws Exception {
        WritableValue target = new WritableValue((Object)"", String.class);
        WritableValue model = new WritableValue((Object)"2", String.class);
        class Validator
        implements IValidator {
            Validator() {
            }

            public IStatus validate(Object value) {
                return ValidationStatus.error((String)"error");
            }
        }
        Binding binding = this.dbc.bindValue((IObservableValue)target, (IObservableValue)model, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new Validator()), null);
        DatabindingContextTest.assertEquals((int)4, (int)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    protected void assertNoErrorsFound() {
        IStatus status = AggregateValidationStatus.getStatusMaxSeverity((Collection)this.dbc.getBindings());
        DatabindingContextTest.assertTrue((String)("No errors should be found, but found " + status), (boolean)status.isOK());
    }

    protected void assertErrorsFound() {
        IStatus status = AggregateValidationStatus.getStatusMaxSeverity((Collection)this.dbc.getBindings());
        DatabindingContextTest.assertFalse((String)"Errors should be found, but found none.", (boolean)status.isOK());
    }

    private static class BindingStub
    extends Binding {
        public BindingStub() {
            super((IObservable)new WritableValue(), (IObservable)new WritableValue());
        }

        public IObservableValue getValidationStatus() {
            return null;
        }

        public void updateTargetToModel() {
        }

        public void updateModelToTarget() {
        }

        protected void postInit() {
        }

        protected void preInit() {
        }

        public void validateModelToTarget() {
        }

        public void validateTargetToModel() {
        }
    }
}

