/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.SetBinding;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;

public class SetBindingTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet<String> target;
    private IObservableSet<String> model;
    private DataBindingContext dbc;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.target = new WritableSet();
        this.model = new WritableSet();
        this.dbc = new DataBindingContext();
    }

    @Override
    public void tearDown() throws Exception {
        this.dbc.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    public void testUpdateModelFromTarget() throws Exception {
        this.target.add((Object)"1");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER), new UpdateSetStrategy());
        SetBindingTest.assertEquals((String)"target != model", this.target, this.model);
    }

    public void testUpdateTargetFromModel() throws Exception {
        this.model.add((Object)"1");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(), new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER));
        SetBindingTest.assertEquals((String)("model != target" + this.model + this.target), this.model, this.target);
    }

    public void testAddListenerAndInitialSyncAreUninterruptable() {
        Policy.setLog((ILogger)new ILogger(){

            public void log(IStatus status) {
                if (!status.isOK()) {
                    Assert.fail((String)("The databinding logger has the not-ok status " + status));
                }
            }
        });
        this.model.add((Object)"first");
        new SetBinding(this.target, this.model, new UpdateSetStrategy(), new UpdateSetStrategy());
        this.model.remove((Object)"first");
    }

    public void testTargetValueIsSyncedToModelIfModelWasNotSyncedToTarget() {
        this.target.add((Object)"first");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE), new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER));
        SetBindingTest.assertEquals((int)this.model.size(), (int)this.target.size());
    }
}

