/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.conversion.DateToStringConverter;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToBigIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToByteConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToDoubleConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToFloatConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToLongConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToShortConverter;
import org.eclipse.core.internal.databinding.conversion.StatusToStringConverter;
import org.eclipse.core.internal.databinding.conversion.StringToBooleanConverter;
import org.eclipse.core.internal.databinding.conversion.StringToBooleanPrimitiveConverter;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;
import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.eclipse.core.internal.databinding.conversion.StringToDateConverter;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class UpdateStrategyTest
extends AbstractDefaultRealmTestCase {
    private static Class[] primitiveNumberTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static Class[] boxedNumberTypes = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class};

    public void testDefaultConverterForStringToInteger() throws Exception {
        this.assertDefaultConverter(String.class, Integer.class, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToIntegerPrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Integer.TYPE, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToLong() throws Exception {
        this.assertDefaultConverter(String.class, Long.class, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToLongPrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Long.TYPE, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToDouble() throws Exception {
        this.assertDefaultConverter(String.class, Double.class, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToDoublePrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Double.TYPE, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToFloat() throws Exception {
        this.assertDefaultConverter(String.class, Float.class, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToFloatPrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Float.TYPE, StringToNumberConverter.class);
    }

    public void testDefaultConverterForStringToBigInteger() throws Exception {
        this.assertDefaultConverter(String.class, BigInteger.class, StringToNumberConverter.class);
    }

    public void testDefaultConverterForIntegerToString() throws Exception {
        this.assertDefaultConverter(Integer.class, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForIntegerPrimitiveToString() throws Exception {
        this.assertDefaultConverter(Integer.TYPE, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForLongToString() throws Exception {
        this.assertDefaultConverter(Long.class, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForLongPrimitiveToString() throws Exception {
        this.assertDefaultConverter(Long.TYPE, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForDoubleToString() throws Exception {
        this.assertDefaultConverter(Double.class, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForDoublePrimitiveToString() throws Exception {
        this.assertDefaultConverter(Double.TYPE, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForFloatToString() throws Exception {
        this.assertDefaultConverter(Float.class, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForFloatPrimitiveToString() throws Exception {
        this.assertDefaultConverter(Float.TYPE, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForBigIntegerToString() throws Exception {
        this.assertDefaultConverter(BigInteger.class, String.class, NumberToStringConverter.class);
    }

    public void testDefaultConverterForDateToString() throws Exception {
        this.assertDefaultConverter(Date.class, String.class, DateToStringConverter.class);
    }

    public void testDefaultConverterForStringToBoolean() throws Exception {
        this.assertDefaultConverter(String.class, Boolean.class, StringToBooleanConverter.class);
    }

    public void testDefaultConverterForStringToBooleanPrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Boolean.TYPE, StringToBooleanPrimitiveConverter.class);
    }

    public void testDefaultConverterForStringToByte() throws Exception {
        this.assertDefaultConverter(String.class, Byte.class, StringToByteConverter.class);
    }

    public void testDefaultConverterForStringToBytePrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Byte.TYPE, StringToByteConverter.class);
    }

    public void testDefaultConverterForStringToCharacter() throws Exception {
        this.assertDefaultConverter(String.class, Character.class, StringToCharacterConverter.class);
    }

    public void testDefaultConverterForStringToDate() throws Exception {
        this.assertDefaultConverter(String.class, Date.class, StringToDateConverter.class);
    }

    public void testDefaultConverterForStringToShort() throws Exception {
        this.assertDefaultConverter(String.class, Short.class, StringToShortConverter.class);
    }

    public void testDefaultConverterForStringToShortPrimitive() throws Exception {
        this.assertDefaultConverter(String.class, Short.TYPE, StringToShortConverter.class);
    }

    public void testDefaultConverterForByteToString() throws Exception {
        this.assertDefaultConverter(Byte.class, String.class, IntegerToStringConverter.class);
    }

    public void testDefaultConverterForBytePrimitiveToString() throws Exception {
        this.assertDefaultConverter(Byte.TYPE, String.class, IntegerToStringConverter.class);
    }

    public void testDefaultConverterForShortToString() throws Exception {
        this.assertDefaultConverter(Short.class, String.class, IntegerToStringConverter.class);
    }

    public void testDefaultConverterForShortPrimitiveToString() throws Exception {
        this.assertDefaultConverter(Short.TYPE, String.class, IntegerToStringConverter.class);
    }

    public void testDefaultConverterForStatusToString() throws Exception {
        this.assertDefaultConverter(IStatus.class, String.class, StatusToStringConverter.class);
    }

    public void testDefaultConverterForNumberToByte() throws Exception {
        this.assertFromNumberToNumberConverter(Byte.class, Byte.TYPE, NumberToByteConverter.class);
    }

    public void testDefaultConverterForNumberToShort() throws Exception {
        this.assertFromNumberToNumberConverter(Short.class, Short.TYPE, NumberToShortConverter.class);
    }

    public void testDefaultConverterForNumberToShortPrimitive() throws Exception {
        this.assertFromNumberToNumberConverter(Short.TYPE, Short.class, NumberToShortConverter.class);
    }

    public void testDefaultConverterForNumberToInteger() throws Exception {
        this.assertFromNumberToNumberConverter(Integer.class, Integer.TYPE, NumberToIntegerConverter.class);
    }

    public void testDefaultConverterForNumberToIntegerPrimitive() throws Exception {
        this.assertFromNumberToNumberConverter(Integer.TYPE, Integer.class, NumberToIntegerConverter.class);
    }

    public void testDefaultConverterForNumberToLong() throws Exception {
        this.assertFromNumberToNumberConverter(Long.class, Long.TYPE, NumberToLongConverter.class);
    }

    public void testDefaultConverterForNumberToLongPrimitive() throws Exception {
        this.assertFromNumberToNumberConverter(Long.TYPE, Long.class, NumberToLongConverter.class);
    }

    public void testDefaultConverterForNumberToFloat() throws Exception {
        this.assertFromNumberToNumberConverter(Float.class, Float.TYPE, NumberToFloatConverter.class);
    }

    public void testDefaultConverterForNumberToFloatPrimitive() throws Exception {
        this.assertFromNumberToNumberConverter(Float.TYPE, Float.class, NumberToFloatConverter.class);
    }

    public void testDefaultConverterForNumberToDouble() throws Exception {
        this.assertFromNumberToNumberConverter(Double.class, Double.TYPE, NumberToDoubleConverter.class);
    }

    public void testDefaultConverterForNumberToDoublePrimitive() throws Exception {
        this.assertFromNumberToNumberConverter(Double.TYPE, Double.class, NumberToDoubleConverter.class);
    }

    public void testDefaultConverterForNumberToBigInteger() throws Exception {
        this.assertFromNumberToNumberConverter(BigInteger.class, null, NumberToBigIntegerConverter.class);
    }

    public void testDefaultConverterForNumberToBigDecimal() throws Exception {
        this.assertFromNumberToNumberConverter(BigDecimal.class, null, NumberToBigDecimalConverter.class);
    }

    private void assertFromNumberToNumberConverter(Class toType, Class toCounterPrimitiveType, Class converterType) {
        int i = 0;
        while (i < primitiveNumberTypes.length) {
            Class primitiveType = primitiveNumberTypes[i];
            if (!primitiveType.equals(toType) && !primitiveType.equals(toCounterPrimitiveType)) {
                this.assertDefaultConverter(primitiveType, toType, converterType);
            } else if (!primitiveType.equals(toType)) {
                this.assertDefaultConverter(primitiveType, toType, IdentityConverter.class);
            }
            ++i;
        }
        i = 0;
        while (i < boxedNumberTypes.length) {
            Class boxedType = boxedNumberTypes[i];
            if (!boxedType.equals(toType) && !boxedType.equals(toCounterPrimitiveType)) {
                this.assertDefaultConverter(boxedType, toType, converterType);
            } else if (!boxedType.equals(toType)) {
                this.assertDefaultConverter(boxedType, toType, IdentityConverter.class);
            }
            ++i;
        }
    }

    private void assertDefaultConverter(Class fromType, Class toType, Class converterType) {
        WritableValue source = WritableValue.withValueType((Object)fromType);
        WritableValue destination = WritableValue.withValueType((Object)toType);
        UpdateStrategyStub strategy = new UpdateStrategyStub();
        strategy.fillDefaults((IObservableValue)source, (IObservableValue)destination);
        IConverter converter = strategy.converter;
        UpdateStrategyTest.assertNotNull((String)"converter not null", (Object)converter);
        UpdateStrategyTest.assertEquals((String)("fromType [" + fromType + "]"), (Object)fromType, (Object)converter.getFromType());
        UpdateStrategyTest.assertEquals((String)("toType [" + toType + "]"), (Object)toType, (Object)converter.getToType());
        UpdateStrategyTest.assertTrue((String)("converter should be instanceof " + converterType + " but was instanceof " + converter.getClass()), (boolean)converterType.isInstance(converter));
    }

    class UpdateStrategyStub
    extends UpdateValueStrategy {
        IConverter converter;

        UpdateStrategyStub() {
        }

        protected void fillDefaults(IObservableValue source, IObservableValue destination) {
            super.fillDefaults(source, destination);
        }

        public UpdateValueStrategy setConverter(IConverter converter) {
            this.converter = converter;
            return super.setConverter(converter);
        }
    }
}

