/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.internal.databinding.validation.NumberToByteValidator;
import org.eclipse.core.internal.databinding.validation.NumberToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.NumberToFloatValidator;
import org.eclipse.core.internal.databinding.validation.NumberToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.NumberToLongValidator;
import org.eclipse.core.internal.databinding.validation.NumberToShortValidator;
import org.eclipse.core.internal.databinding.validation.NumberToUnboundedNumberValidator;
import org.eclipse.core.internal.databinding.validation.StringToByteValidator;
import org.eclipse.core.internal.databinding.validation.StringToDateValidator;
import org.eclipse.core.internal.databinding.validation.StringToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.StringToFloatValidator;
import org.eclipse.core.internal.databinding.validation.StringToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.StringToLongValidator;
import org.eclipse.core.internal.databinding.validation.StringToShortValidator;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class UpdateValueStrategyTest
extends AbstractDefaultRealmTestCase {
    public void testDefaultValidatorForStringToInteger() throws Exception {
        this.assertDefaultValidator(String.class, Integer.class, StringToIntegerValidator.class);
    }

    public void testDefaultValidatorForStringToIntegerPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Integer.TYPE, StringToIntegerValidator.class);
    }

    public void testDefaultValidatorForStringToLong() throws Exception {
        this.assertDefaultValidator(String.class, Long.class, StringToLongValidator.class);
    }

    public void testDefaultValidatorForStringToLongPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Long.TYPE, StringToLongValidator.class);
    }

    public void testDefaultValidatorForStringToFloat() throws Exception {
        this.assertDefaultValidator(String.class, Float.class, StringToFloatValidator.class);
    }

    public void testDefaultValidatorForStringToFloatPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Float.TYPE, StringToFloatValidator.class);
    }

    public void testDefaultValidatorForStringToDouble() throws Exception {
        this.assertDefaultValidator(String.class, Double.class, StringToDoubleValidator.class);
    }

    public void testDefaultValidatorForStringToDoublePrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Double.TYPE, StringToDoubleValidator.class);
    }

    public void testDefaultValidatorForStringToByte() throws Exception {
        this.assertDefaultValidator(String.class, Byte.class, StringToByteValidator.class);
    }

    public void testDefaultValidatorForStringToBytePrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Byte.TYPE, StringToByteValidator.class);
    }

    public void testDefaultValidatorForStringToShort() throws Exception {
        this.assertDefaultValidator(String.class, Short.class, StringToShortValidator.class);
    }

    public void testDefaultValidatorForStringToShortPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Short.TYPE, StringToShortValidator.class);
    }

    public void testDefaultValidatorForStringToDate() throws Exception {
        this.assertDefaultValidator(String.class, Date.class, StringToDateValidator.class);
    }

    public void testDefaultValidatorForNumberToByte() throws Exception {
        this.assertDefaultValidator(Integer.class, Byte.class, NumberToByteValidator.class);
    }

    public void testDefaultValidatorForNumberToShort() throws Exception {
        this.assertDefaultValidator(Integer.class, Short.class, NumberToShortValidator.class);
    }

    public void testDefaultValidatorForNumberToInteger() throws Exception {
        this.assertDefaultValidator(Short.class, Integer.class, NumberToIntegerValidator.class);
    }

    public void testDefaultValidatorForNumberToLong() throws Exception {
        this.assertDefaultValidator(Short.class, Long.class, NumberToLongValidator.class);
    }

    public void testDefaultValidatorForNumberToFloat() throws Exception {
        this.assertDefaultValidator(Short.class, Float.class, NumberToFloatValidator.class);
    }

    public void testDefaultValidatorForNumberToDouble() throws Exception {
        this.assertDefaultValidator(Short.class, Double.class, NumberToDoubleValidator.class);
    }

    public void testDefaultValidatorForNumberToBigInteger() throws Exception {
        this.assertDefaultValidator(Short.class, BigInteger.class, NumberToUnboundedNumberValidator.class);
    }

    public void testDefaultValidatorForNumberToBigDecimal() throws Exception {
        this.assertDefaultValidator(Short.class, BigDecimal.class, NumberToUnboundedNumberValidator.class);
    }

    public void testCachesDefaultedValidators() throws Exception {
        WritableValue source = WritableValue.withValueType(String.class);
        WritableValue destination = WritableValue.withValueType(Integer.class);
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults((IObservableValue)source, (IObservableValue)destination);
        IValidator validator = strategy.validator;
        UpdateValueStrategyTest.assertNotNull((Object)validator);
        strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults((IObservableValue)source, (IObservableValue)destination);
        UpdateValueStrategyTest.assertSame((Object)validator, (Object)strategy.validator);
    }

    public void testFillDefaults_AssertSourceTypeExtendsConverterFromType() {
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        strategy.fillDefaults((IObservableValue)WritableValue.withValueType(String.class), (IObservableValue)WritableValue.withValueType(Object.class));
        strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(String.class, Object.class));
        try {
            strategy.fillDefaults((IObservableValue)WritableValue.withValueType(Object.class), (IObservableValue)WritableValue.withValueType(Object.class));
            UpdateValueStrategyTest.fail((String)"Expected BindingException since Object does not extend String");
        }
        catch (BindingException bindingException) {}
    }

    public void testFillDefaults_AssertConverterToTypeExtendsDestinationType() {
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, String.class));
        strategy.fillDefaults((IObservableValue)WritableValue.withValueType(Object.class), (IObservableValue)WritableValue.withValueType(Object.class));
        strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        try {
            strategy.fillDefaults((IObservableValue)WritableValue.withValueType(Object.class), (IObservableValue)WritableValue.withValueType(String.class));
            UpdateValueStrategyTest.fail((String)"Expected BindingException since Object does not extend String");
        }
        catch (BindingException bindingException) {}
    }

    private void assertDefaultValidator(Class fromType, Class toType, Class validatorType) {
        WritableValue source = WritableValue.withValueType((Object)fromType);
        WritableValue destination = WritableValue.withValueType((Object)toType);
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults((IObservableValue)source, (IObservableValue)destination);
        IValidator validator = strategy.validator;
        UpdateValueStrategyTest.assertNotNull((String)"validator not null", (Object)validator);
        UpdateValueStrategyTest.assertTrue((String)("converter instanceof " + validatorType), (boolean)validatorType.isInstance(validator));
    }

    class UpdateValueStrategyStub
    extends UpdateValueStrategy {
        IValidator validator;

        UpdateValueStrategyStub() {
        }

        protected void fillDefaults(IObservableValue source, IObservableValue destination) {
            super.fillDefaults(source, destination);
        }

        protected IValidator createValidator(Object fromType, Object toType) {
            this.validator = super.createValidator(fromType, toType);
            return this.validator;
        }
    }
}

