/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ValueBindingTest
extends AbstractDefaultRealmTestCase {
    private WritableValue target;
    private WritableValue model;
    private DataBindingContext dbc;
    private Binding binding;
    private List log;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.target = WritableValue.withValueType(String.class);
        this.model = WritableValue.withValueType(String.class);
        this.dbc = new DataBindingContext();
        this.log = new ArrayList();
    }

    @Override
    public void tearDown() throws Exception {
        this.dbc.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    public void testNoUpdateTargetFromModel() throws Exception {
        try {
            new DataBindingContext().bindValue((IObservableValue)new ObservableValueStub(), (IObservableValue)new ObservableValueStub(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }
        catch (Exception e) {
            ValueBindingTest.fail((String)e.getMessage());
        }
    }

    public void testValuePropagation() throws Exception {
        String initialValue = "value";
        this.model.setValue((Object)initialValue);
        ValueBindingTest.assertFalse((boolean)this.model.getValue().equals(this.target.getValue()));
        this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model);
        ValueBindingTest.assertEquals((Object)this.target.getValue(), (Object)this.model.getValue());
    }

    public void testGetTarget() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model);
        ValueBindingTest.assertEquals((Object)this.target, (Object)binding.getTarget());
    }

    public void testGetModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model);
        ValueBindingTest.assertEquals((Object)this.model, (Object)binding.getModel());
    }

    public void testOKStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        ValueBindingTest.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
    }

    public void testWarningStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, new UpdateValueStrategy().setAfterGetValidator(this.warningValidator()), null);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        ValueBindingTest.assertEquals((String)"warning status", (int)2, (int)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    public void testInfoStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, new UpdateValueStrategy().setAfterGetValidator(this.infoValidator()), null);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        ValueBindingTest.assertEquals((String)"info status", (int)1, (int)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    public void testErrorStatusInValidationDoesNotUpdateModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, new UpdateValueStrategy().setAfterGetValidator(this.errorValidator()), null);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertFalse((String)"value not copied to model", (boolean)value.equals(this.model.getValue()));
        ValueBindingTest.assertEquals((String)"error status", (int)4, (int)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    public void testCancelStatusInValidationDoesNotUpdateModel() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, new UpdateValueStrategy().setAfterGetValidator(this.cancelValidator()), null);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertFalse((String)"value not copied to model", (boolean)value.equals(this.model.getValue()));
        ValueBindingTest.assertEquals((String)"cancel status", (int)8, (int)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    public void testStatusesFromEveryPhaseAreReturned() throws Exception {
        UpdateValueStrategy strategy = new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                super.doSet(observableValue, value);
                return ValidationStatus.info((String)"");
            }
        };
        strategy.setAfterGetValidator(this.warningValidator());
        strategy.setAfterConvertValidator(this.infoValidator());
        strategy.setBeforeSetValidator(this.warningValidator());
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, strategy, null);
        String value = "value";
        ValueBindingTest.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        ValueBindingTest.assertEquals((Object)value, (Object)this.model.getValue());
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        ValueBindingTest.assertTrue((boolean)status.isMultiStatus());
        ValueBindingTest.assertEquals((String)"max status", (int)2, (int)status.getSeverity());
        MultiStatus multiStatus = (MultiStatus)status;
        ValueBindingTest.assertEquals((int)4, (int)multiStatus.getChildren().length);
        IStatus[] children = multiStatus.getChildren();
        ValueBindingTest.assertEquals((String)"after get severity", (int)2, (int)children[0].getSeverity());
        ValueBindingTest.assertEquals((String)"after convert severity", (int)1, (int)children[1].getSeverity());
        ValueBindingTest.assertEquals((String)"before set severity", (int)2, (int)children[2].getSeverity());
        ValueBindingTest.assertEquals((String)"doSet severity", (int)1, (int)children[3].getSeverity());
    }

    public void testStatusIsInstanceOfBindingStatus() throws Exception {
        Binding binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model);
        ValueBindingTest.assertTrue((boolean)(binding.getValidationStatus().getValue() instanceof BindingStatus));
    }

    public void testDiffsAreCheckedForEqualityBeforeUpdate() throws Exception {
        class WritableValueStub
        extends WritableValue {
            public WritableValueStub() {
                super((Object)"", String.class);
            }

            protected void fireValueChange(ValueDiff diff) {
                super.fireValueChange(diff);
            }
        }
        WritableValueStub target = new WritableValueStub();
        WritableValue model = WritableValue.withValueType(String.class);
        class Strategy
        extends UpdateValueStrategy {
            int afterGetCount;

            Strategy() {
            }

            public IStatus validateAfterGet(Object value) {
                ++this.afterGetCount;
                return super.validateAfterGet(value);
            }
        }
        Strategy strategy = new Strategy();
        this.dbc.bindValue((IObservableValue)target, (IObservableValue)model, (UpdateValueStrategy)strategy, null);
        int count = strategy.afterGetCount;
        target.fireValueChange(Diffs.createValueDiff((Object)"", (Object)""));
        ValueBindingTest.assertEquals((String)"update does not occur", (int)count, (int)strategy.afterGetCount);
    }

    public void testPostInit_UpdatePolicy_UpdateToTarget_UpdateToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_UPDATE), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        ValueBindingTest.assertEquals(Arrays.asList("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), (Object)this.log);
    }

    public void testPostInit_UpdatePolicy_UpdateToTarget_ConvertToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_CONVERT), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        ValueBindingTest.assertEquals(Arrays.asList("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), (Object)this.log);
    }

    public void testPostInit_UpdatePolicy_UpdateToTarget_OnRequestToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        ValueBindingTest.assertEquals(Arrays.asList("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set"), (Object)this.log);
        this.log.clear();
        this.target.setValue(new Object());
        ValueBindingTest.assertEquals(Collections.singletonList("target-set"), (Object)this.log);
        this.log.clear();
        this.binding.validateTargetToModel();
        ValueBindingTest.assertEquals(Arrays.asList("target-get", "target-convert", "target-after-convert", "model-before-set"), (Object)this.log);
        this.log.clear();
        this.binding.updateTargetToModel();
        ValueBindingTest.assertEquals(Arrays.asList("target-get", "target-convert", "target-after-convert", "model-before-set", "model-set"), (Object)this.log);
    }

    public void testPostInit_UpdatePolicy_UpdateToTarget_NeverToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_NEVER), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        ValueBindingTest.assertEquals(Arrays.asList("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set"), (Object)this.log);
        this.log.clear();
        this.target.setValue(new Object());
        ValueBindingTest.assertEquals(Collections.singletonList("target-set"), (Object)this.log);
        this.log.clear();
        this.binding.validateTargetToModel();
        ValueBindingTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.log);
        this.log.clear();
        this.binding.updateTargetToModel();
        ValueBindingTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.log);
    }

    public void testPostInit_UpdatePolicy_ConvertToTarget_UpdateToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_UPDATE), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_CONVERT));
        ValueBindingTest.assertEquals(Arrays.asList("model-get", "model-convert", "model-after-convert", "target-before-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), (Object)this.log);
        this.log.clear();
        this.target.setValue(new Object());
        ValueBindingTest.assertEquals(Arrays.asList("target-set", "target-get", "target-convert", "target-after-convert", "model-before-set", "model-set"), (Object)this.log);
        this.log.clear();
        this.model.setValue(new Object());
        ValueBindingTest.assertEquals(Arrays.asList("model-set", "model-get", "model-convert", "model-after-convert"), (Object)this.log);
    }

    public void testTargetValueIsSyncedToModelIfModelWasNotSyncedToTarget() {
        this.bindLoggingValue(new UpdateValueStrategy(true, UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(true, UpdateValueStrategy.POLICY_NEVER));
        ValueBindingTest.assertEquals((Object)this.model.getValue(), (Object)this.target.getValue());
    }

    private void bindLoggingValue(UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        this.model.setValue((Object)"1");
        this.target.setValue((Object)"2");
        this.target.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ValueBindingTest.this.log.add("target-set");
            }
        });
        this.model.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ValueBindingTest.this.log.add("model-set");
            }
        });
        this.binding = this.dbc.bindValue((IObservableValue)this.target, (IObservableValue)this.model, targetToModel, modelToTarget);
    }

    private UpdateValueStrategy loggingModelToTargetStrategy(int updatePolicy) {
        return new UpdateValueStrategy(updatePolicy).setAfterGetValidator(this.loggingValidator(this.log, "model-get")).setConverter(this.loggingConverter(this.log, "model-convert")).setAfterConvertValidator(this.loggingValidator(this.log, "model-after-convert")).setBeforeSetValidator(this.loggingValidator(this.log, "target-before-set"));
    }

    private UpdateValueStrategy loggingTargetToModelStrategy(int updatePolicy) {
        return new UpdateValueStrategy(updatePolicy).setAfterGetValidator(this.loggingValidator(this.log, "target-get")).setConverter(this.loggingConverter(this.log, "target-convert")).setAfterConvertValidator(this.loggingValidator(this.log, "target-after-convert")).setBeforeSetValidator(this.loggingValidator(this.log, "model-before-set"));
    }

    private IValidator loggingValidator(final List log, final String message) {
        return new IValidator(){

            public IStatus validate(Object value) {
                log.add(message);
                return ValidationStatus.ok();
            }
        };
    }

    private IConverter loggingConverter(final List log, final String message) {
        return new Converter(null, null){

            public Object convert(Object fromObject) {
                log.add(message);
                return fromObject;
            }
        };
    }

    private IValidator warningValidator() {
        return new IValidator(){

            public IStatus validate(Object value) {
                return ValidationStatus.warning((String)"");
            }
        };
    }

    private IValidator infoValidator() {
        return new IValidator(){

            public IStatus validate(Object value) {
                return ValidationStatus.info((String)"");
            }
        };
    }

    private IValidator errorValidator() {
        return new IValidator(){

            public IStatus validate(Object value) {
                return ValidationStatus.error((String)"");
            }
        };
    }

    private IValidator cancelValidator() {
        return new IValidator(){

            public IStatus validate(Object value) {
                return ValidationStatus.cancel((String)"");
            }
        };
    }

    private static class ObservableValueStub
    extends AbstractObservableValue {
        private ObservableValueStub() {
        }

        protected Object doGetValue() {
            return null;
        }

        public Object getValueType() {
            return null;
        }

        protected void doSetValue(Object value) {
        }
    }
}

