/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import java.util.Arrays;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BeansObservablesTest
extends AbstractDefaultRealmTestCase {
    Bean[] elements = null;
    Bean model = null;
    Class<?> elementType = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.elements = new Bean[]{new Bean("1"), new Bean("2"), new Bean("3")};
        this.model = new Bean(this.elements);
        this.model.setList(Arrays.asList(this.elements));
        this.elementType = Bean.class;
    }

    public void testObserveListArrayInferredElementType() throws Exception {
        IObservableList list = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"list", null);
        BeansObservablesTest.assertEquals((String)"element type", Object.class, (Object)list.getElementType());
    }

    public void testObserveListNonInferredElementType() throws Exception {
        this.elementType = Object.class;
        IObservableList list = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"list", null);
        BeansObservablesTest.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
    }

    public void testListFactory() throws Exception {
        IObservableFactory factory = BeansObservables.listFactory((Realm)Realm.getDefault(), (String)"list", this.elementType);
        IObservableList list = (IObservableList)factory.createObservable((Object)this.model);
        BeansObservablesTest.assertTrue((String)"elements of the list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
        BeansObservablesTest.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
    }

    public void testObserveDetailListElementType() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        parent.setValue((Object)this.model);
        IObservableList list = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", this.elementType);
        BeansObservablesTest.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
        BeansObservablesTest.assertTrue((String)"elements of list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
    }

    public void testObserveDetailValueIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableValue detailValue = BeansObservables.observeDetailValue((IObservableValue)parent, (String)"value", String.class);
        BeansObservablesTest.assertTrue((boolean)(detailValue instanceof IBeanObservable));
        BeanObservableValueDecorator beanObservable = (BeanObservableValueDecorator)detailValue;
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getValue", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate", (boolean)beanObservable.getDecorated().getClass().getName().endsWith("DetailObservableValue"));
    }

    public void testObserveDetailValueNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableValue detailValue = BeansObservables.observeDetailValue((IObservableValue)parent, (String)"value", String.class);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailValue).getPropertyDescriptor());
    }

    public void testObservableDetailListIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableList detailList = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", Bean.class);
        BeansObservablesTest.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailList instanceof IBeanObservable));
        BeanObservableListDecorator beanObservable = (BeanObservableListDecorator)detailList;
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getList", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailList));
    }

    public void testObservableDetailListNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableList detailList = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", Bean.class);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailList).getPropertyDescriptor());
    }

    public void testObservableDetailSetIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableSet detailSet = BeansObservables.observeDetailSet((IObservableValue)parent, (String)"set", Bean.class);
        BeansObservablesTest.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailSet instanceof IBeanObservable));
        BeanObservableSetDecorator beanObservable = (BeanObservableSetDecorator)detailSet;
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getSet", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailSet));
    }

    public void testObservableDetailSetNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableSet detailSet = BeansObservables.observeDetailSet((IObservableValue)parent, (String)"set", Bean.class);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailSet).getPropertyDescriptor());
    }

    public void testObserveSetElementType() throws Exception {
        Bean bean = new Bean();
        IObservableSet observableSet = BeansObservables.observeSet((Realm)Realm.getDefault(), (Object)bean, (String)"set", Bean.class);
        BeansObservablesTest.assertEquals(Bean.class, (Object)observableSet.getElementType());
    }

    public void testObserveSetNonInferredElementType() throws Exception {
        Bean bean = new Bean();
        IObservableSet observableSet = BeansObservables.observeSet((Realm)Realm.getDefault(), (Object)bean, (String)"set");
        BeansObservablesTest.assertEquals(Object.class, (Object)observableSet.getElementType());
    }

    public void testHandleExternalChangeToProperty() {
        Bean targetBean = new Bean();
        IObservableList modelObservable = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"array", this.elementType);
        IObservableList targetObservable = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)targetBean, (String)"array", this.elementType);
        DataBindingContext context = new DataBindingContext(Realm.getDefault());
        try {
            context.bindList(targetObservable, modelObservable);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(this.elements, targetBean.getArray()));
            Object[] newElements = new Bean[]{new Bean("4"), new Bean("5"), new Bean("6")};
            this.model.setArray(newElements);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(newElements, targetBean.getArray()));
            newElements = new Bean[]{new Bean("7"), new Bean("8"), new Bean("9")};
            targetBean.setArray(newElements);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(newElements, this.model.getArray()));
        }
        finally {
            context.dispose();
        }
    }

    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = BeanProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        BeansObservablesTest.assertEquals(Bean.class, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = BeanProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        BeansObservablesTest.assertEquals(String.class, (Object)valueObservable.getValueType());
    }
}

