/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class PojoObservablesTest
extends AbstractDefaultRealmTestCase {
    private Bean pojo;
    private String propertyName;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.pojo = new Bean();
        this.propertyName = "value";
    }

    public void testObserveValue_ReturnsIBeanObservable() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)value);
        PojoObservablesTest.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    public void testObserveValue_DoesNotAttachListeners() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)value);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    public void testObservableValueWithRealm_ReturnsIBeanObservable() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        IObservableValue value = PojoObservables.observeValue((Realm)realm, (Object)this.pojo, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)value);
        PojoObservablesTest.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    public void testObservableMap_ReturnsIBeanObservable() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)new Bean());
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, Bean.class, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)map);
        PojoObservablesTest.assertTrue((boolean)(map instanceof IBeanObservable));
    }

    public void testObservableMap_DoesNotAttachListeners() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, Bean.class, (String)this.propertyName);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
        ChangeEventTracker.observe((IObservable)map);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    public void testObserveMaps_ReturnsMaps() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        IObservableMap[] maps = PojoObservables.observeMaps((IObservableSet)set, Bean.class, (String[])new String[]{"value", "class"});
        PojoObservablesTest.assertEquals((int)2, (int)maps.length);
    }

    public void testObserveListWithElementType_ReturnsIBeanObservable() throws Exception {
        IObservableList list = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list", String.class);
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveListWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list", String.class);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    public void testObserveList_ReturnsIBeanObservable() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        PojoObservablesTest.assertTrue((boolean)(observable instanceof IBeanObservable));
    }

    public void testObserveList_DoesNotAttachListeners() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    public void testObserveSetWithElementType_ReturnsIBeanObservable() throws Exception {
        IObservableSet list = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set", String.class);
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveSetWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableSet observable = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set", String.class);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testObserveSet_ReturnsIBeanObservable() throws Exception {
        IObservableSet list = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveSet_DoesNotAttachListeners() throws Exception {
        IObservableSet observable = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testValueFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.valueFactory((Realm)Realm.getDefault(), (String)"value");
        IObservableValue observable = (IObservableValue)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    public void testListFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.listFactory((Realm)Realm.getDefault(), (String)"list", String.class);
        IObservableList observable = (IObservableList)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    public void testSetFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.setFactory((Realm)Realm.getDefault(), (String)this.propertyName);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testSetFactoryWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.setFactory((Realm)Realm.getDefault(), (String)this.propertyName, String.class);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = PojoProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        PojoObservablesTest.assertEquals(Bean.class, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = PojoProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        PojoObservablesTest.assertEquals(String.class, (Object)valueObservable.getValueType());
    }
}

