/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;

public class NumberToStringConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private NumberFormat integerFormat;
    Class icuBigDecimal = null;
    Constructor icuBigDecimalCtr = null;

    public NumberToStringConverterTest() {
        try {
            this.icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            this.icuBigDecimalCtr = this.icuBigDecimal.getConstructor(BigInteger.class, Integer.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getNumberInstance();
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    public void testFromTypes() throws Exception {
        NumberToStringConverterTest.assertEquals((String)"Integer.class", Integer.class, (Object)NumberToStringConverter.fromInteger((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Integer.TYPE", Integer.TYPE, (Object)NumberToStringConverter.fromInteger((boolean)true).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Double.class", Double.class, (Object)NumberToStringConverter.fromDouble((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Double.TYPE", Double.TYPE, (Object)NumberToStringConverter.fromDouble((boolean)true).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Long.class", Long.class, (Object)NumberToStringConverter.fromLong((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Long.TYPE", Long.TYPE, (Object)NumberToStringConverter.fromLong((boolean)true).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Float.class", Float.class, (Object)NumberToStringConverter.fromFloat((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Float.TYPE", Float.TYPE, (Object)NumberToStringConverter.fromFloat((boolean)true).getFromType());
        NumberToStringConverterTest.assertEquals((String)"BigInteger.class", BigInteger.class, (Object)NumberToStringConverter.fromBigInteger().getFromType());
        NumberToStringConverterTest.assertEquals((String)"BigDecimal.class", BigDecimal.class, (Object)NumberToStringConverter.fromBigDecimal().getFromType());
        NumberToStringConverterTest.assertEquals((String)"Short.class", Short.class, (Object)NumberToStringConverter.fromShort((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Byte.class", Byte.class, (Object)NumberToStringConverter.fromByte((boolean)false).getFromType());
    }

    public void testToTypeIsStringClass() throws Exception {
        NumberToStringConverterTest.assertEquals(String.class, (Object)NumberToStringConverter.fromInteger((boolean)false).getToType());
    }

    public void testConvertIntegerToString() throws Exception {
        Integer input = 1000;
        String expected = this.integerFormat.format(input.longValue());
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertDoubleToString() throws Exception {
        Double input = new Double(1000.1);
        String expected = this.numberFormat.format(input.doubleValue());
        NumberToStringConverter converter = NumberToStringConverter.fromDouble((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertFloatToString() throws Exception {
        Float input = new Float(1000.1f);
        String expected = this.numberFormat.format((double)input.floatValue());
        NumberToStringConverter converter = NumberToStringConverter.fromFloat((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertLongToString() throws Exception {
        Long input = new Long(1000L);
        String expected = this.integerFormat.format(input.longValue());
        NumberToStringConverter converter = NumberToStringConverter.fromLong((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertBigIntegerToString() throws Exception {
        BigInteger input = BigInteger.valueOf(1000L);
        String expected = this.integerFormat.format(input);
        NumberToStringConverter converter = NumberToStringConverter.fromBigInteger();
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    private String formatBigDecimal(BigDecimal javabd) throws Exception {
        if (this.icuBigDecimal != null && this.icuBigDecimalCtr != null) {
            Number icubd = (Number)this.icuBigDecimalCtr.newInstance(javabd.unscaledValue(), javabd.scale());
            return this.numberFormat.format((Object)icubd);
        }
        throw new IllegalArgumentException("ICU not present. Cannot reliably format large BigDecimal values; needed for testing. Java platforms prior to 1.5 fail to format/parse these decimals correctly.");
    }

    public void testConvertBigDecimalToString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromBigDecimal();
        BigDecimal input = new BigDecimal("100.23");
        String expected = this.formatBigDecimal(input);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Non-integer BigDecimal", (String)expected, (String)result);
        input = new BigDecimal(2147483747L);
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Integral BigDecimal in long range", (String)expected, (String)result);
        input = new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(100L)));
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Integral BigDecimal in BigInteger range", (String)expected, (String)result);
        input = new BigDecimal("100404101.233456783456788934567893456789231982001345678234567890");
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"High-precision BigDecimal", (String)expected, (String)result);
    }

    public void testNullSourceConvertsToEmptyString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        NumberToStringConverterTest.assertEquals((Object)"", (Object)converter.convert(null));
    }
}

