/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.ObservableStaleContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class AbstractObservableTest
extends AbstractDefaultRealmTestCase {
    private ObservableStub observable;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.observable = new ObservableStub(Realm.getDefault());
    }

    public void testStaleListener() throws Exception {
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        StaleEventTracker listener1 = new StaleEventTracker();
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        this.observable.addStaleListener((IStaleListener)listener1);
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        this.observable.firstListenerAdded = false;
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertEquals((int)0, (int)listener1.count);
        this.observable.fireStale();
        AbstractObservableTest.assertEquals((int)1, (int)listener1.count);
        AbstractObservableTest.assertSame((Object)((Object)this.observable), (Object)listener1.event.getObservable());
        StaleEventTracker listener2 = new StaleEventTracker();
        AbstractObservableTest.assertEquals((int)0, (int)listener2.count);
        this.observable.addStaleListener((IStaleListener)listener2);
        this.observable.fireStale();
        AbstractObservableTest.assertEquals((int)2, (int)listener1.count);
        AbstractObservableTest.assertEquals((int)1, (int)listener2.count);
        StaleEventTracker listener3 = new StaleEventTracker();
        this.observable.addStaleListener((IStaleListener)listener3);
        AbstractObservableTest.assertEquals((int)0, (int)listener3.count);
        this.observable.fireStale();
        AbstractObservableTest.assertEquals((int)3, (int)listener1.count);
        AbstractObservableTest.assertEquals((int)2, (int)listener2.count);
        AbstractObservableTest.assertEquals((int)1, (int)listener3.count);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener((IStaleListener)listener1);
        this.observable.removeStaleListener((IStaleListener)listener2);
        this.observable.removeStaleListener((IStaleListener)listener3);
        AbstractObservableTest.assertTrue((boolean)this.observable.lastListenerRemoved);
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
    }

    public void testChangeListener() throws Exception {
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        ChangeEventTracker listener1 = new ChangeEventTracker();
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        this.observable.addChangeListener((IChangeListener)listener1);
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        this.observable.firstListenerAdded = false;
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertEquals((int)0, (int)listener1.count);
        this.observable.fireChange();
        AbstractObservableTest.assertEquals((int)1, (int)listener1.count);
        AbstractObservableTest.assertSame((Object)((Object)this.observable), (Object)listener1.event.getSource());
        ChangeEventTracker listener2 = new ChangeEventTracker();
        this.observable.addChangeListener((IChangeListener)listener2);
        AbstractObservableTest.assertEquals((int)0, (int)listener2.count);
        this.observable.fireChange();
        AbstractObservableTest.assertEquals((int)2, (int)listener1.count);
        AbstractObservableTest.assertEquals((int)1, (int)listener2.count);
        ChangeEventTracker listener3 = new ChangeEventTracker();
        this.observable.addChangeListener((IChangeListener)listener3);
        AbstractObservableTest.assertEquals((int)0, (int)listener3.count);
        this.observable.fireChange();
        AbstractObservableTest.assertEquals((int)3, (int)listener1.count);
        AbstractObservableTest.assertEquals((int)2, (int)listener2.count);
        AbstractObservableTest.assertEquals((int)1, (int)listener3.count);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeChangeListener((IChangeListener)listener1);
        this.observable.removeChangeListener((IChangeListener)listener2);
        this.observable.removeChangeListener((IChangeListener)listener3);
        AbstractObservableTest.assertTrue((boolean)this.observable.lastListenerRemoved);
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
    }

    public void testHasListenersWithChangeAndStaleListeners() throws Exception {
        ChangeEventTracker changeListener = new ChangeEventTracker();
        StaleEventTracker staleListener = new StaleEventTracker();
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.addChangeListener((IChangeListener)changeListener);
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.firstListenerAdded = false;
        this.observable.lastListenerRemoved = false;
        this.observable.addStaleListener((IStaleListener)staleListener);
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeChangeListener((IChangeListener)changeListener);
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener((IStaleListener)staleListener);
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertTrue((boolean)this.observable.lastListenerRemoved);
    }

    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractObservableTest.this.observable = new ObservableStub();
                AbstractObservableTest.this.observable.fireStale();
            }
        });
    }

    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractObservableTest.this.observable = new ObservableStub();
                AbstractObservableTest.this.observable.fireChange();
            }
        });
    }

    public void testAddDisposeListener_HasListenersFalse() {
        IDisposeListener disposeListener = new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
            }
        };
        IStaleListener staleListener = new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        };
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        this.observable.addDisposeListener(disposeListener);
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertFalse((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.addStaleListener(staleListener);
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeDisposeListener(disposeListener);
        AbstractObservableTest.assertTrue((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener(staleListener);
        AbstractObservableTest.assertFalse((boolean)this.observable.hasListeners());
        AbstractObservableTest.assertTrue((boolean)this.observable.firstListenerAdded);
        AbstractObservableTest.assertTrue((boolean)this.observable.lastListenerRemoved);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AbstractObservableTest.class.getName());
        suite.addTestSuite(AbstractObservableTest.class);
        Delegate delegate = new Delegate();
        suite.addTest(ObservableContractTest.suite((IObservableContractDelegate)delegate));
        suite.addTest(ObservableStaleContractTest.suite((IObservableContractDelegate)delegate));
        return suite;
    }

    static class Delegate
    extends AbstractObservableContractDelegate {
        Delegate() {
        }

        public void change(IObservable observable) {
            ((ObservableStub)observable).fireChange();
        }

        public void setStale(IObservable observable, boolean stale) {
            ((ObservableStub)observable).setStale(stale);
        }

        public IObservable createObservable(Realm realm) {
            return new ObservableStub(realm);
        }
    }

    private static class ObservableStub
    extends AbstractObservable {
        private boolean stale;
        private boolean firstListenerAdded;
        private boolean lastListenerRemoved;

        public ObservableStub() {
            this(Realm.getDefault());
        }

        public ObservableStub(Realm realm) {
            super(realm);
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }

        public boolean isStale() {
            this.getterCalled();
            return this.stale;
        }

        private void getterCalled() {
            ObservableTracker.getterCalled((IObservable)this);
        }

        public void setStale(boolean stale) {
            boolean old = this.stale;
            this.stale = stale;
            if (stale && !old) {
                this.fireStale();
            }
        }

        protected boolean hasListeners() {
            return super.hasListeners();
        }

        protected void firstListenerAdded() {
            this.firstListenerAdded = true;
        }

        protected void lastListenerRemoved() {
            this.lastListenerRemoved = true;
        }
    }
}

