/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeSupport;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ChangeSupportTest
extends AbstractDefaultRealmTestCase {
    private ChangeSupportStub changeSupport;
    private static final String ADD_FIRST = "firstListenerAdded";
    private static final String REMOVE_LAST = "lastListenerRemoved";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.changeSupport = new ChangeSupportStub(Realm.getDefault());
    }

    public void testAddDisposeListener_HasListenersFalse() {
        IDisposeListener disposeListener = new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
            }
        };
        IStaleListener staleListener = new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        };
        ChangeSupportTest.assertFalse((boolean)this.changeSupport.hasListeners());
        this.changeSupport.addDisposeListener(disposeListener);
        ChangeSupportTest.assertFalse((boolean)this.changeSupport.hasListeners());
        ChangeSupportTest.assertEquals((Object)Collections.EMPTY_LIST, this.changeSupport.log);
        this.changeSupport.addStaleListener(staleListener);
        ChangeSupportTest.assertTrue((boolean)this.changeSupport.hasListeners());
        ChangeSupportTest.assertEquals(Collections.singletonList(ADD_FIRST), this.changeSupport.log);
        this.changeSupport.removeDisposeListener(disposeListener);
        ChangeSupportTest.assertTrue((boolean)this.changeSupport.hasListeners());
        ChangeSupportTest.assertEquals(Collections.singletonList(ADD_FIRST), this.changeSupport.log);
        this.changeSupport.removeStaleListener(staleListener);
        ChangeSupportTest.assertFalse((boolean)this.changeSupport.hasListeners());
        ChangeSupportTest.assertEquals(Arrays.asList(ADD_FIRST, REMOVE_LAST), this.changeSupport.log);
    }

    private static class ChangeSupportStub
    extends ChangeSupport {
        List<String> log = new ArrayList<String>();

        ChangeSupportStub(Realm realm) {
            super(realm);
        }

        protected void firstListenerAdded() {
            this.log.add(ChangeSupportTest.ADD_FIRST);
        }

        protected void lastListenerRemoved() {
            this.log.add(ChangeSupportTest.REMOVE_LAST);
        }

        protected boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

