/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;

public class Diffs_ListDiffTests
extends TestCase {
    public void testListDiffEntryToStringDoesNotThrowNPEForNullListDiffEntry() {
        ListDiffEntry entry = new ListDiffEntry(){

            public Object getElement() {
                return null;
            }

            public int getPosition() {
                return 0;
            }

            public boolean isAddition() {
                return false;
            }
        };
        try {
            entry.toString();
            Diffs_ListDiffTests.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Diffs_ListDiffTests.fail((String)"NPE was thrown.");
        }
    }

    public void testListDiffToStringDoesNotThrowNPEForNullListDiff() {
        ListDiff diff = new ListDiff(){

            public ListDiffEntry[] getDifferences() {
                return null;
            }
        };
        try {
            diff.toString();
            Diffs_ListDiffTests.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Diffs_ListDiffTests.fail((String)"NPE was thrown.");
        }
    }

    public void testListDiffToStringDoesNotThrowNPEForNullListDiffEntry() {
        ListDiff diff = new ListDiff(){

            public ListDiffEntry[] getDifferences() {
                return new ListDiffEntry[1];
            }
        };
        try {
            diff.toString();
            Diffs_ListDiffTests.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Diffs_ListDiffTests.fail((String)"NPE was thrown.");
        }
    }

    public void testDiffScenario1() throws Exception {
        ListDiff diff = this.diff(null, null);
        Diffs_ListDiffTests.assertEquals((int)0, (int)diff.getDifferences().length);
    }

    private ListDiff diff(String[] oldArray, String[] newArray) {
        List<String> a = Arrays.asList(oldArray != null ? oldArray : new String[]{});
        List<String> b = Arrays.asList(newArray != null ? newArray : new String[]{});
        return Diffs.computeListDiff(a, b);
    }

    public void testDiffScenario2() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, null);
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
    }

    public void testDiffScenario3() throws Exception {
        ListDiff diff = this.diff(null, new String[]{"a"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
    }

    public void testDiffScenario4() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a"});
        Diffs_ListDiffTests.assertEquals((int)0, (int)diff.getDifferences().length);
    }

    public void testDiffScenario5() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b"});
        Diffs_ListDiffTests.assertEquals((int)2, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], false, 1, "a");
    }

    public void testDiffScenario6() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a", "b"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 1, "b");
    }

    public void testDiffScenario7() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b", "a"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
    }

    public void testDiffScenario8() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b", "b"});
        Diffs_ListDiffTests.assertEquals((int)3, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 1, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], false, 2, "a");
    }

    public void testDiffScenario9() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a", "b", "c"});
        Diffs_ListDiffTests.assertEquals((int)2, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 1, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 2, "c");
    }

    public void testDiffScenario10() throws Exception {
        ListDiff diff = this.diff(new String[]{"b"}, new String[]{"a", "b", "c"});
        Diffs_ListDiffTests.assertEquals((int)2, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 2, "c");
    }

    public void testDiffScenario11() throws Exception {
        ListDiff diff = this.diff(new String[]{"c"}, new String[]{"a", "b", "c"});
        Diffs_ListDiffTests.assertEquals((int)2, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 1, "b");
    }

    public void testDiffScenario12() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "b", "c"});
        Diffs_ListDiffTests.assertEquals((int)0, (int)diff.getDifferences().length);
    }

    public void testDiffScenario13() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"b", "c"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
    }

    public void testDiffScenarios14() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "c"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 1, "b");
    }

    public void testDiffScenarios15() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "b"});
        Diffs_ListDiffTests.assertEquals((int)1, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 2, "c");
    }

    public void testDiffScenarios16() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"c", "b", "a"});
        Diffs_ListDiffTests.assertEquals((int)4, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 2, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 0, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], false, 2, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[3], true, 1, "b");
    }

    public void testDiffScenarios17() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"c", "b"});
        Diffs_ListDiffTests.assertEquals((int)3, (int)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], false, 1, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], true, 0, "c");
    }

    private static void assertEntry(ListDiffEntry entry, boolean addition, int position, String element) {
        Diffs_ListDiffTests.assertEquals((String)"addition", (boolean)addition, (boolean)entry.isAddition());
        Diffs_ListDiffTests.assertEquals((String)"position", (int)position, (int)entry.getPosition());
        Diffs_ListDiffTests.assertEquals((String)"element", (Object)element, (Object)entry.getElement());
    }

    public void testComputeListDiff_SingleInsert() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "c"), Arrays.asList("a", "b", "c"));
    }

    public void testComputeListDiff_SingleAppend() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("a", "b", "c"));
    }

    public void testComputeListDiff_SingleRemove() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("a", "b"));
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("a", "c"));
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("b", "c"));
    }

    public void testComputeListDiff_MoveDown1() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("b", "a"));
    }

    public void testComputeListDiff_MoveDown2() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("b", "c", "a"));
    }

    public void testComputeListDiff_MoveUp1() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("b", "a"));
    }

    public void testComputeListDiff_MoveUp2() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("c", "a", "b"));
    }

    private static void checkComputedListDiff(List<Object> oldList, List<Object> newList) {
        ListDiff diff = Diffs.computeListDiff(oldList, newList);
        final ArrayList<Object> list = new ArrayList<Object>(oldList);
        diff.accept(new ListDiffVisitor(){

            public void handleAdd(int index, Object element) {
                list.add(index, element);
            }

            public void handleRemove(int index, Object element) {
                Diffs_ListDiffTests.assertEquals((Object)element, list.remove(index));
            }

            public void handleReplace(int index, Object oldElement, Object newElement) {
                Diffs_ListDiffTests.assertEquals((Object)oldElement, (Object)list.set(index, newElement));
            }
        });
        Diffs_ListDiffTests.assertEquals((String)"Applying diff to old list should make it equal to new list", newList, list);
    }
}

