/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.IdentitySet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ObservableTrackerTest
extends AbstractDefaultRealmTestCase {
    public void testRunAndMonitor_GetterCalled() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor((Runnable)new Runnable((IObservable)observable){
            private final /* synthetic */ IObservable val$observable;
            {
                this.val$observable = iObservable;
            }

            @Override
            public void run() {
                ObservableTracker.getterCalled((IObservable)this.val$observable);
            }
        }, null, null);
        ObservableTrackerTest.assertEquals((int)1, (int)result.length);
        ObservableTrackerTest.assertSame((Object)((Object)observable), (Object)result[0]);
    }

    public void testGetterCalled_ObservableDisposed() throws Exception {
        try {
            ObservableStub observable = new ObservableStub();
            observable.dispose();
            ObservableTracker.getterCalled((IObservable)observable);
            ObservableTrackerTest.fail((String)"expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testGetterCalled_ObservableRealmNotCurrent() throws Exception {
        try {
            ObservableStub observable = new ObservableStub((Realm)new CurrentRealm(false));
            ObservableTracker.getterCalled((IObservable)observable);
            ObservableTrackerTest.fail((String)"expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testRunAndCollect() throws Exception {
        final IObservable[] created = new IObservable[1];
        IObservable[] collected = ObservableTracker.runAndCollect((Runnable)new Runnable(){

            @Override
            public void run() {
                created[0] = new ObservableStub();
            }
        });
        ObservableTrackerTest.assertEquals((int)1, (int)collected.length);
        ObservableTrackerTest.assertSame((Object)created[0], (Object)collected[0]);
    }

    public void testRunAndIgnore_RunAndMonitor() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor((Runnable)new Runnable((IObservable)observable){
            private final /* synthetic */ IObservable val$observable;
            {
                this.val$observable = iObservable;
            }

            @Override
            public void run() {
                ObservableTracker.runAndIgnore((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObservableTracker.getterCalled((IObservable)val$observable);
                    }
                });
            }
        }, null, null);
        ObservableTrackerTest.assertEquals((int)0, (int)result.length);
    }

    public void testRunAndIgnore_RunAndCollect() throws Exception {
        IObservable[] result = ObservableTracker.runAndCollect((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableTracker.runAndIgnore((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        new ObservableStub();
                    }
                });
            }
        });
        ObservableTrackerTest.assertEquals((int)0, (int)result.length);
    }

    public void testSetIgnore_RunAndMonitor() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor((Runnable)new Runnable((IObservable)observable){
            private final /* synthetic */ IObservable val$observable;
            {
                this.val$observable = iObservable;
            }

            @Override
            public void run() {
                ObservableTracker.setIgnore((boolean)true);
                ObservableTracker.getterCalled((IObservable)this.val$observable);
                ObservableTracker.setIgnore((boolean)false);
            }
        }, null, null);
        ObservableTrackerTest.assertEquals((int)0, (int)result.length);
    }

    public void testSetIgnore_RunAndCollect() throws Exception {
        IObservable[] result = ObservableTracker.runAndCollect((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableTracker.setIgnore((boolean)true);
                new ObservableStub();
                ObservableTracker.setIgnore((boolean)false);
            }
        });
        ObservableTrackerTest.assertEquals((int)0, (int)result.length);
    }

    public void testSetIgnore_Nested_RunAndCollect() throws Exception {
        final ArrayList list = new ArrayList();
        IdentitySet collected = new IdentitySet(Arrays.asList(ObservableTracker.runAndCollect((Runnable)new Runnable(){

            @Override
            public void run() {
                list.add(new ObservableStub());
                ObservableTracker.setIgnore((boolean)true);
                list.add(new ObservableStub());
                ObservableTracker.setIgnore((boolean)true);
                list.add(new ObservableStub());
                ObservableTracker.setIgnore((boolean)false);
                list.add(new ObservableStub());
                ObservableTracker.setIgnore((boolean)false);
                list.add(new ObservableStub());
            }
        })));
        IdentitySet expected = new IdentitySet();
        expected.add((ObservableStub)((Object)list.get(0)));
        expected.add((ObservableStub)((Object)list.get(4)));
        ObservableTrackerTest.assertEquals((Object)expected, (Object)collected);
    }

    public void testSetIgnore_Nested_RunAndMonitor() throws Exception {
        final IObservable[] observables = new IObservable[]{new ObservableStub(), new ObservableStub(), new ObservableStub(), new ObservableStub(), new ObservableStub()};
        IdentitySet result = new IdentitySet(Arrays.asList(ObservableTracker.runAndMonitor((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableTracker.getterCalled((IObservable)observables[0]);
                ObservableTracker.setIgnore((boolean)true);
                ObservableTracker.getterCalled((IObservable)observables[1]);
                ObservableTracker.setIgnore((boolean)true);
                ObservableTracker.getterCalled((IObservable)observables[2]);
                ObservableTracker.setIgnore((boolean)false);
                ObservableTracker.getterCalled((IObservable)observables[3]);
                ObservableTracker.setIgnore((boolean)false);
                ObservableTracker.getterCalled((IObservable)observables[4]);
            }
        }, null, null)));
        IdentitySet expected = new IdentitySet();
        expected.add(observables[0]);
        expected.add(observables[4]);
        ObservableTrackerTest.assertEquals((Object)expected, (Object)result);
    }

    public void testSetIgnore_RunAndMonitor_UnmatchedIgnore_LogsError() {
        final ArrayList log = new ArrayList();
        Policy.setLog((ILogger)new ILogger(){

            public void log(IStatus status) {
                log.add(status);
            }
        });
        ObservableTracker.runAndMonitor((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableTracker.setIgnore((boolean)true);
            }
        }, null, null);
        ObservableTrackerTest.assertEquals((int)1, (int)log.size());
        IStatus status = (IStatus)log.get(0);
        ObservableTrackerTest.assertEquals((int)4, (int)status.getSeverity());
        ObservableTrackerTest.assertTrue((status.getMessage().indexOf("setIgnore") != -1 ? 1 : 0) != 0);
    }

    public void testSetIgnore_RunAndCollect_UnmatchedIgnore_LogsError() {
        final ArrayList log = new ArrayList();
        Policy.setLog((ILogger)new ILogger(){

            public void log(IStatus status) {
                log.add(status);
            }
        });
        ObservableTracker.runAndCollect((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableTracker.setIgnore((boolean)true);
            }
        });
        ObservableTrackerTest.assertEquals((int)1, (int)log.size());
        IStatus status = (IStatus)log.get(0);
        ObservableTrackerTest.assertEquals((int)4, (int)status.getSeverity());
        ObservableTrackerTest.assertTrue((status.getMessage().indexOf("setIgnore") != -1 ? 1 : 0) != 0);
    }

    public void testSetIgnore_UnmatchedUnignore() {
        try {
            ObservableTracker.setIgnore((boolean)false);
            ObservableTrackerTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static class ObservableStub
    extends AbstractObservable {
        public ObservableStub() {
            this(Realm.getDefault());
        }

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return false;
        }
    }
}

