/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ComputedListTest
extends AbstractDefaultRealmTestCase {
    ComputedListStub list;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.list = new ComputedListStub();
        this.list.size();
    }

    public void testDependency_Staleness() {
        ComputedListTest.assertFalse((boolean)this.list.isStale());
        this.list.dependency.fireStale();
        ComputedListTest.assertTrue((boolean)this.list.isStale());
    }

    public void testDependency_FiresListChange() {
        ComputedListTest.assertEquals((Object)this.list.nextComputation, (Object)((Object)this.list));
        Object element = new Object();
        this.list.nextComputation.add(element);
        this.list.dependency.fireChange();
        ArrayList<Object> expectedList = new ArrayList<Object>();
        expectedList.add(element);
        ComputedListTest.assertEquals(expectedList, (Object)((Object)this.list));
    }

    public void testDependency_NoStaleEventIfAlreadyDirty() {
        this.list.dependency.fireChange();
        this.list.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
                ComputedListTest.fail((String)"Should not fire stale when list is already dirty");
            }
        });
        this.list.dependency.fireStale();
    }

    public void testDependency_ListChangeEventFiresOnlyWhenNotDirty() {
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)this.list);
        this.list.dependency.fireChange();
        ComputedListTest.assertEquals((String)"ComputedList should fire list change event when its dependency changes", (int)1, (int)tracker.count);
        this.list.dependency.fireChange();
        ComputedListTest.assertEquals((String)"ComputedList should not fire list change events when dirty", (int)1, (int)tracker.count);
        this.list.size();
        this.list.dependency.fireChange();
        ComputedListTest.assertEquals((String)"ComputedList should fire list change event when its dependency changes", (int)2, (int)tracker.count);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ComputedListTest.class.getName());
        suite.addTestSuite(ComputedListTest.class);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class ComputedListStub
    extends ComputedList {
        List nextComputation = new ArrayList();
        ObservableStub dependency;

        ComputedListStub() {
            this(Realm.getDefault());
        }

        ComputedListStub(Realm realm) {
            super(realm);
            this.dependency = new ObservableStub(realm);
        }

        protected List calculate() {
            ObservableTracker.getterCalled((IObservable)this.dependency);
            return new ArrayList(this.nextComputation);
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            ComputedListStub list = new ComputedListStub(realm);
            int i = 0;
            while (i < elementCount) {
                list.nextComputation.add(this.createElement((IObservableCollection)list));
                ++i;
            }
            list.size();
            return list;
        }

        public void change(IObservable observable) {
            ComputedListStub list = (ComputedListStub)observable;
            list.nextComputation.add(new Object());
            list.dependency.fireChange();
        }

        public void setStale(IObservable observable, boolean stale) {
            if (stale) {
                ((ComputedListStub)observable).dependency.fireStale();
            } else {
                ComputedListStub computedList = (ComputedListStub)observable;
                computedList.dependency.stale = false;
                computedList.dependency.fireChange();
            }
        }
    }

    static class ObservableStub
    extends AbstractObservable {
        boolean stale;

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return this.stale;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }
}

