/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class MultiListTest
extends AbstractDefaultRealmTestCase {
    MultiListStub multiList;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        WritableList[] lists = new WritableList[]{new WritableList(), new WritableList()};
        this.multiList = new MultiListStub(Realm.getDefault(), lists);
    }

    public void testIsStale_FollowsSublist() {
        MultiListTest.assertFalse((boolean)this.multiList.isStale());
        this.multiList.subLists[0].setStale(true);
        MultiListTest.assertTrue((boolean)this.multiList.isStale());
        this.multiList.subLists[0].setStale(false);
        MultiListTest.assertFalse((boolean)this.multiList.isStale());
    }

    public void testDependency_FiresListChange() {
        ArrayList<Object> expectedList = new ArrayList<Object>();
        MultiListTest.assertEquals(expectedList, (Object)((Object)this.multiList));
        Object element = new Object();
        expectedList.add(element);
        this.multiList.subLists[0].add(element);
        MultiListTest.assertEquals(expectedList, (Object)((Object)this.multiList));
    }

    public void testStaleEvent_NoFireEventIfAlreadyStale() {
        this.multiList.subLists[0].setStale(true);
        this.multiList.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
                MultiListTest.fail((String)"Should not fire stale when list is already dirty");
            }
        });
        this.multiList.subLists[1].setStale(true);
    }

    public void testModifySubList_FiresListChangeEventFromMultiList() {
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)this.multiList);
        Object element0 = new Object();
        this.multiList.subLists[0].add(element0);
        MultiListTest.assertEquals((int)1, (int)tracker.count);
        ListDiffEntry[] differences = tracker.event.diff.getDifferences();
        MultiListTest.assertEquals((int)1, (int)differences.length);
        this.assertEntry(differences[0], 0, true, element0);
        Object element1 = new Object();
        this.multiList.subLists[1].add(element1);
        MultiListTest.assertEquals((int)2, (int)tracker.count);
        differences = tracker.event.diff.getDifferences();
        MultiListTest.assertEquals((int)1, (int)differences.length);
        this.assertEntry(differences[0], 1, true, element1);
        Object element2 = new Object();
        this.multiList.subLists[0].add(element2);
        MultiListTest.assertEquals((int)3, (int)tracker.count);
        differences = tracker.event.diff.getDifferences();
        MultiListTest.assertEquals((int)1, (int)differences.length);
        this.assertEntry(differences[0], 1, true, element2);
    }

    private void assertEntry(ListDiffEntry entry, int position, boolean addition, Object element) {
        MultiListTest.assertEquals((Object)element, (Object)entry.getElement());
        MultiListTest.assertEquals((boolean)addition, (boolean)entry.isAddition());
        MultiListTest.assertEquals((int)position, (int)entry.getPosition());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MultiListTest.class.getName());
        suite.addTestSuite(MultiListTest.class);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList[] subLists = new WritableList[]{new WritableList(realm), new WritableList(realm)};
            MultiListStub list = new MultiListStub(realm, subLists);
            int i = 0;
            while (i < elementCount) {
                list.subLists[0].add(this.createElement((IObservableCollection)list));
                ++i;
            }
            return list;
        }

        public void change(IObservable observable) {
            MultiListStub list = (MultiListStub)observable;
            list.subLists[0].add(new Object());
        }

        public void setStale(IObservable observable, boolean stale) {
            ((MultiListStub)observable).subLists[0].setStale(stale);
        }
    }

    private static class MultiListStub
    extends MultiList {
        WritableList[] subLists;

        MultiListStub(Realm realm, WritableList[] lists) {
            super(realm, (IObservableList[])lists);
            this.subLists = lists;
        }
    }
}

