/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class ObservableListTest
extends TestCase {
    private ObservableListStub list;

    protected void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.list = new ObservableListStub(new ArrayList(0), Object.class);
    }

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testIsStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableListTest.this.list.isStale();
            }
        });
    }

    public void testSetStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableListTest.this.list.setStale(false);
            }
        });
    }

    public void testMove_FiresListChanges() throws Exception {
        this.list = new MutableObservableListStub();
        Object element = new Object();
        this.list.add(0, element);
        this.list.add(1, new Object());
        final ArrayList diffEntries = new ArrayList();
        this.list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                diffEntries.addAll(Arrays.asList(event.diff.getDifferences()));
            }
        });
        this.list.move(0, 1);
        ObservableListTest.assertEquals((int)2, (int)diffEntries.size());
        ListDiffEntry entry = (ListDiffEntry)diffEntries.get(0);
        ObservableListTest.assertEquals((Object)element, (Object)entry.getElement());
        ObservableListTest.assertEquals((boolean)false, (boolean)entry.isAddition());
        ObservableListTest.assertEquals((int)0, (int)entry.getPosition());
        entry = (ListDiffEntry)diffEntries.get(1);
        ObservableListTest.assertEquals((Object)element, (Object)entry.getElement());
        ObservableListTest.assertEquals((boolean)true, (boolean)entry.isAddition());
        ObservableListTest.assertEquals((int)1, (int)entry.getPosition());
    }

    public void testMove_MovesElement() throws Exception {
        this.list = new MutableObservableListStub();
        Object element0 = new Object();
        Object element1 = new Object();
        this.list.add(0, element0);
        this.list.add(1, element1);
        this.list.move(0, 1);
        ObservableListTest.assertEquals((Object)element1, (Object)this.list.get(0));
        ObservableListTest.assertEquals((Object)element0, (Object)this.list.get(1));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ObservableListTest.class.getName());
        suite.addTestSuite(ObservableListTest.class);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            ArrayList<String> wrappedList = new ArrayList<String>();
            int i = 0;
            while (i < elementCount) {
                wrappedList.add(String.valueOf(i));
                ++i;
            }
            return new MutableObservableListStub(realm, wrappedList, String.class);
        }

        public void change(IObservable observable) {
            ObservableListStub list = (ObservableListStub)observable;
            String element = "element";
            list.wrappedList.add(element);
            list.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)list.size(), (boolean)true, (Object)element)));
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }
    }

    static class MutableObservableListStub
    extends ObservableListStub {
        MutableObservableListStub() {
            this(Realm.getDefault(), new ArrayList(), null);
        }

        MutableObservableListStub(Realm realm, List wrappedList, Object elementType) {
            super(realm, wrappedList, elementType);
        }

        public void add(int index, Object element) {
            this.checkRealm();
            this.wrappedList.add(index, element);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
        }

        public Object remove(int index) {
            this.checkRealm();
            Object element = this.wrappedList.remove(index);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, element)));
            return element;
        }
    }

    static class ObservableListStub
    extends ObservableList {
        List wrappedList;

        ObservableListStub(Realm realm, List wrappedList, Object elementType) {
            super(realm, wrappedList, elementType);
            this.wrappedList = wrappedList;
        }

        ObservableListStub(List wrappedList, Object elementType) {
            super(wrappedList, elementType);
            this.wrappedList = wrappedList;
        }

        protected void fireListChange(ListDiff diff) {
            super.fireListChange(diff);
        }
    }
}

