/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.BidiObservableMap;
import org.eclipse.core.databinding.observable.map.BidirectionalMap;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BidiObservableMapTest
extends AbstractDefaultRealmTestCase {
    private IObservableMap wrappedMap;
    private BidiObservableMap bidiMap;
    private Object key1;
    private Object key2;
    private Object value1;
    private Object value2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedMap = new WritableMap();
        this.bidiMap = new BidiObservableMap(this.wrappedMap);
        this.key1 = new Object();
        this.key2 = new Object();
        this.value1 = new Object();
        this.value2 = new Object();
    }

    public void testConstructor_NullArgument() {
        try {
            new BidirectionalMap(null);
            BidiObservableMapTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void withAndWithoutListeners(Runnable runnable) throws Exception {
        runnable.run();
        this.tearDown();
        this.setUp();
        ChangeEventTracker.observe((IObservable)this.wrappedMap);
        runnable.run();
    }

    public void testGetKeys_Empty() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
            }
        });
    }

    public void testGetKeys_NullKey() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.this.wrappedMap.put(null, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.assertEquals(Collections.singleton(null), (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
            }
        });
    }

    public void testGetKeys_NullValue() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, null);
                BidiObservableMapTest.assertEquals(Collections.singleton(BidiObservableMapTest.this.key1), (Object)BidiObservableMapTest.this.bidiMap.getKeys(null));
            }
        });
    }

    public void testGetKeys_SinglePut() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.assertEquals(Collections.singleton(BidiObservableMapTest.this.key1), (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
            }
        });
    }

    public void testGetKeys_ReplaceValue() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.assertEquals(Collections.singleton(BidiObservableMapTest.this.key1), (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value2));
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, BidiObservableMapTest.this.value2);
                BidiObservableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.assertEquals(Collections.singleton(BidiObservableMapTest.this.key1), (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value2));
            }
        });
    }

    public void testGetKeys_MultipleKeysWithSameValue() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key2, BidiObservableMapTest.this.value1);
                HashSet<Object> expected = new HashSet<Object>();
                expected.add(BidiObservableMapTest.this.key1);
                expected.add(BidiObservableMapTest.this.key2);
                BidiObservableMapTest.assertEquals(expected, (Object)BidiObservableMapTest.this.bidiMap.getKeys(BidiObservableMapTest.this.value1));
            }
        });
    }

    public void testContainsValue_PutAndRemove() throws Exception {
        this.withAndWithoutListeners(new Runnable(){

            @Override
            public void run() {
                BidiObservableMapTest.assertFalse((boolean)BidiObservableMapTest.this.bidiMap.containsValue(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key1, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.assertTrue((boolean)BidiObservableMapTest.this.bidiMap.containsValue(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.this.wrappedMap.put(BidiObservableMapTest.this.key2, BidiObservableMapTest.this.value1);
                BidiObservableMapTest.assertTrue((boolean)BidiObservableMapTest.this.bidiMap.containsValue(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.this.wrappedMap.remove(BidiObservableMapTest.this.key1);
                BidiObservableMapTest.assertTrue((boolean)BidiObservableMapTest.this.bidiMap.containsValue(BidiObservableMapTest.this.value1));
                BidiObservableMapTest.this.wrappedMap.remove(BidiObservableMapTest.this.key2);
                BidiObservableMapTest.assertFalse((boolean)BidiObservableMapTest.this.bidiMap.containsValue(BidiObservableMapTest.this.value1));
            }
        });
    }
}

