/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class ObservableMapTest
extends TestCase {
    ObservableMapStub map;

    protected void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.map = new ObservableMapStub(new HashMap());
    }

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testDisposeMapChangeListeners() throws Exception {
        MapChangeEventTracker listener = MapChangeEventTracker.observe((IObservableMap)this.map);
        ObservableMapTest.assertEquals((int)0, (int)listener.count);
        this.map.fireMapChange(null);
        ObservableMapTest.assertEquals((int)1, (int)listener.count);
        this.map.dispose();
        try {
            this.map.fireMapChange(null);
        }
        catch (Exception exception) {}
        ObservableMapTest.assertEquals((String)"listener should not have been notified", (int)1, (int)listener.count);
    }

    public void testIsStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableMapTest.this.map.isStale();
            }
        });
    }

    public void testSetStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableMapTest.this.map.setStale(true);
            }
        });
    }

    public void testFireMapChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                ObservableMapTest.this.map.fireMapChange(null);
            }
        });
    }

    public void testEquals() {
        ObservableMapTest.assertTrue((boolean)this.map.equals(Collections.EMPTY_MAP));
    }

    static class ObservableMapStub
    extends ObservableMap {
        public ObservableMapStub(Map wrappedMap) {
            super(wrappedMap);
        }

        protected void fireMapChange(MapDiff diff) {
            super.fireMapChange(diff);
        }
    }
}

