/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class WritableMapTest
extends TestCase {
    protected void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
    }

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testPutRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                WritableMap map = new WritableMap();
                map.put((Object)"", (Object)"");
            }
        });
    }

    public void testRemoveRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                WritableMap map = new WritableMap();
                CurrentRealm realm = (CurrentRealm)Realm.getDefault();
                boolean current = realm.isCurrent();
                realm.setCurrent(true);
                map.put((Object)"", (Object)"");
                realm.setCurrent(current);
                map.remove((Object)"");
            }
        });
    }

    public void testClearRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                WritableMap map = new WritableMap();
                map.clear();
            }
        });
    }

    public void testPutAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            @Override
            public void run() {
                WritableMap map = new WritableMap();
                map.putAll(Collections.EMPTY_MAP);
            }
        });
    }

    public void testPutWithExistingKeyMapChangeEvent() throws Exception {
        WritableMap map = new WritableMap();
        String key = "key";
        String value = "value";
        map.put((Object)key, (Object)value);
        MapChangeEventTracker listener = new MapChangeEventTracker();
        map.addMapChangeListener((IMapChangeListener)listener);
        WritableMapTest.assertEquals((int)0, (int)listener.count);
        String newValue = "new value";
        map.put((Object)key, (Object)newValue);
        WritableMapTest.assertEquals((int)1, (int)listener.count);
        MapChangeEvent event = listener.event;
        Set changedKeys = event.diff.getChangedKeys();
        WritableMapTest.assertEquals((int)1, (int)changedKeys.size());
        WritableMapTest.assertTrue((boolean)changedKeys.contains(key));
        WritableMapTest.assertEquals((Object)value, (Object)event.diff.getOldValue((Object)key));
        WritableMapTest.assertEquals((Object)newValue, (Object)event.diff.getNewValue((Object)key));
    }

    public void testPutSameValue_NoMapChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        String value = "value";
        map.put(key, (Object)value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        WritableMapTest.assertEquals((int)0, (int)tracker.count);
        String equalValue = new String("value");
        map.put(key, (Object)equalValue);
        WritableMapTest.assertEquals((int)0, (int)tracker.count);
    }

    public void testPutNullKey_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        WritableMapTest.assertEquals((int)0, (int)tracker.count);
        Object key = null;
        Object value = new Object();
        map.put(key, value);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals((Object)value, (Object)diff.getNewValue(key));
    }

    public void testRemoveNullKey_SingleRemovalChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = null;
        Object value = new Object();
        map.put(key, value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        map.remove(key);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals((Object)value, (Object)diff.getOldValue(key));
    }

    public void testPutNullValue_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        WritableMapTest.assertEquals((int)0, (int)tracker.count);
        Object key = new Object();
        Object value = null;
        map.put(key, value);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals(value, (Object)diff.getNewValue(key));
    }

    public void testPutNullOverNonNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = new Object();
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = null;
        map.put(key, newValue);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals((Object)oldValue, (Object)diff.getOldValue(key));
        WritableMapTest.assertEquals(newValue, (Object)diff.getNewValue(key));
    }

    public void testPutNonNullOverNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = null;
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = new Object();
        map.put(key, newValue);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals(oldValue, (Object)diff.getOldValue(key));
        WritableMapTest.assertEquals((Object)newValue, (Object)diff.getNewValue(key));
    }

    public void testRemoveNullValue_SingleRemovalChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object value = null;
        map.put(key, value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        map.remove(key);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals(value, (Object)diff.getOldValue(key));
    }

    public void testPutAllNullValue_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object key = new Object();
        Object value = null;
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, value);
        map.putAll(other);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals(value, (Object)diff.getNewValue(key));
    }

    public void testPutAllNullValueToNonNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = null;
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = new Object();
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, newValue);
        map.putAll(other);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals(oldValue, (Object)diff.getOldValue(key));
        WritableMapTest.assertEquals((Object)newValue, (Object)diff.getNewValue(key));
    }

    public void testPutAllNonNullValueToNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = new Object();
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = null;
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, newValue);
        map.putAll(other);
        WritableMapTest.assertEquals((int)1, (int)tracker.count);
        MapDiff diff = tracker.event.diff;
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getAddedKeys());
        WritableMapTest.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        WritableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        WritableMapTest.assertEquals((Object)oldValue, (Object)diff.getOldValue(key));
        WritableMapTest.assertEquals(newValue, (Object)diff.getNewValue(key));
    }
}

