/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class WritableSetTest
extends AbstractDefaultRealmTestCase {
    public void testWithElementType() throws Exception {
        Class<String> elementType = String.class;
        WritableSet set = WritableSet.withElementType(elementType);
        WritableSetTest.assertNotNull((Object)set);
        WritableSetTest.assertEquals((Object)Realm.getDefault(), (Object)set.getRealm());
        WritableSetTest.assertEquals(elementType, (Object)set.getElementType());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WritableSetTest.class.getName());
        suite.addTestSuite(WritableSetTest.class);
        suite.addTest(MutableObservableSetContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Delegate() {
        }

        public void change(IObservable observable) {
            IObservableSet set = (IObservableSet)observable;
            set.add(this.createElement((IObservableCollection)set));
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableSet set = new WritableSet(realm, (Collection)Collections.EMPTY_SET, String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(this.createElement((IObservableCollection)set));
                ++i;
            }
            return set;
        }
    }
}

