/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DateAndTimeObservableValueTest
extends AbstractDefaultRealmTestCase {
    private IObservableValue date;
    private IObservableValue time;
    private IObservableValue dateAndTime;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.date = WritableValue.withValueType(Date.class);
        this.time = WritableValue.withValueType(Date.class);
        this.dateAndTime = new DateAndTimeObservableValue(this.date, this.time);
    }

    private static Date date(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return calendar.getTime();
    }

    private static Date time(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    private static Date timestamp(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month - 1, day, hour, minute, second);
        return calendar.getTime();
    }

    public void testGetValue_NullDateNullResult() {
        this.date.setValue(null);
        this.time.setValue((Object)DateAndTimeObservableValueTest.time(12, 27, 17));
        DateAndTimeObservableValueTest.assertNull((Object)this.dateAndTime.getValue());
    }

    public void testGetValue_NullTimeClearsTime() {
        this.date.setValue((Object)DateAndTimeObservableValueTest.date(2009, 3, 3));
        this.time.setValue(null);
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 0, 0, 0), (Object)this.dateAndTime.getValue());
    }

    public void testGetValue() {
        this.date.setValue((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 12, 30, 33));
        this.time.setValue((Object)DateAndTimeObservableValueTest.timestamp(1999, 12, 31, 23, 59, 59));
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 23, 59, 59), (Object)this.dateAndTime.getValue());
    }

    public void testSetValue() {
        this.date.setValue((Object)DateAndTimeObservableValueTest.date(2009, 3, 3));
        this.time.setValue((Object)DateAndTimeObservableValueTest.time(12, 32, 55));
        this.dateAndTime.setValue((Object)DateAndTimeObservableValueTest.timestamp(2010, 1, 1, 2, 3, 5));
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.date(2010, 1, 1), (Object)this.date.getValue());
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.time(2, 3, 5), (Object)this.time.getValue());
    }

    public void testSetValue_NullNullsDateClearsTime() {
        this.date.setValue((Object)DateAndTimeObservableValueTest.date(2009, 3, 3));
        this.time.setValue((Object)DateAndTimeObservableValueTest.time(12, 25, 34));
        this.dateAndTime.setValue(null);
        DateAndTimeObservableValueTest.assertEquals(null, (Object)this.date.getValue());
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.time(0, 0, 0), (Object)this.time.getValue());
    }

    public void testSetValue_PreserveTimeOfDateAndDateOfTime() {
        this.date.setValue((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 12, 32, 55));
        this.time.setValue((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 12, 32, 55));
        this.dateAndTime.setValue((Object)DateAndTimeObservableValueTest.timestamp(2010, 1, 1, 2, 3, 5));
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.timestamp(2010, 1, 1, 12, 32, 55), (Object)this.date.getValue());
        DateAndTimeObservableValueTest.assertEquals((Object)DateAndTimeObservableValueTest.timestamp(2009, 3, 3, 2, 3, 5), (Object)this.time.getValue());
    }
}

