/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.DuplexingObservableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DuplexingObservableValueTest
extends AbstractDefaultRealmTestCase {
    private IObservableList list;
    private DuplexingObservableValue observable;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.list = new WritableList(new ArrayList(), String.class);
    }

    public void testValueType_InheritFromTargetList() throws Exception {
        this.observable = new DuplexingObservableValue(this.list){

            protected Object coalesceElements(Collection elements) {
                return null;
            }
        };
        DuplexingObservableValueTest.assertEquals((String)"value type should be the element type of the target list", String.class, (Object)this.observable.getValueType());
    }

    public void testValueType_ProvidedInConstructor() throws Exception {
        this.observable = new DuplexingObservableValue(this.list, Object.class){

            protected Object coalesceElements(Collection elements) {
                return null;
            }
        };
        DuplexingObservableValueTest.assertEquals((String)"value type should be the type passed to constructor", Object.class, (Object)this.observable.getValueType());
    }

    public void test_getValue() throws Exception {
        this.observable = DuplexingObservableValue.withDefaults((IObservableList)this.list, null, (Object)"<Multiple Values>");
        DuplexingObservableValueTest.assertNull((Object)this.observable.getValue());
        this.list.add((Object)"42");
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"42");
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"watermelon");
        DuplexingObservableValueTest.assertEquals((Object)"<Multiple Values>", (Object)this.observable.getValue());
        this.list.remove(2);
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.clear();
        DuplexingObservableValueTest.assertNull((Object)this.observable.getValue());
    }
}

