/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;

public class WritableValueTest
extends AbstractDefaultRealmTestCase {
    public void testConstructor() throws Exception {
        WritableValue value = new WritableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
        WritableValueTest.assertNull((Object)value.getValue());
        WritableValueTest.assertNull((Object)value.getValueType());
    }

    public void testWithValueType() throws Exception {
        Class<String> elementType = String.class;
        WritableValue value = WritableValue.withValueType(elementType);
        WritableValueTest.assertNotNull((Object)value);
        WritableValueTest.assertEquals((Object)Realm.getDefault(), (Object)value.getRealm());
        WritableValueTest.assertEquals(elementType, (Object)value.getValueType());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WritableValueTest.class.getName());
        suite.addTestSuite(WritableValueTest.class);
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            return new WritableValue(realm, (Object)"", String.class);
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }
}

