/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.databinding.observable.ThreadRealm;

public class DifferentRealmsBindingTest
extends TestCase {
    ThreadRealm targetAndModelRealm = new ThreadRealm();
    ThreadRealm validationRealm = new ThreadRealm();
    List<IStatus> errorStatusses = new ArrayList<IStatus>();
    DataBindingContext dbc;
    ILogger logger = new ILogger(){

        public void log(IStatus status) {
            if (!status.isOK()) {
                DifferentRealmsBindingTest.this.errorStatusses.add(status);
            }
        }
    };

    protected void setUp() throws Exception {
        this.errorStatusses.clear();
        new Thread(){

            @Override
            public void run() {
                DifferentRealmsBindingTest.this.targetAndModelRealm.init(Thread.currentThread());
                DifferentRealmsBindingTest.this.targetAndModelRealm.block();
            }
        }.start();
        this.validationRealm.init(Thread.currentThread());
        this.dbc = new DataBindingContext((Realm)this.validationRealm);
        Policy.setLog((ILogger)this.logger);
    }

    protected void tearDown() throws Exception {
        this.dbc.dispose();
    }

    public void testListBindingValidationRealm() throws Throwable {
        WritableList model = new WritableList((Realm)this.targetAndModelRealm);
        WritableList target = new WritableList((Realm)this.targetAndModelRealm);
        this.dbc.bindList((IObservableList)target, (IObservableList)model);
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        DifferentRealmsBindingTest.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }

    public void testSetBindingValidationRealm() throws Throwable {
        WritableSet model = new WritableSet((Realm)this.targetAndModelRealm);
        WritableSet target = new WritableSet((Realm)this.targetAndModelRealm);
        this.dbc.bindSet((IObservableSet)target, (IObservableSet)model);
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        DifferentRealmsBindingTest.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }
}

