/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.identity.IdentityMap;

public class IdentityMapTest
extends TestCase {
    IdentityMap map;
    Object key;
    Object value;
    Map.Entry entry;

    protected void setUp() throws Exception {
        super.setUp();
        this.map = new IdentityMap();
        this.key = new Object();
        this.value = new Object();
        this.entry = new Map.Entry(){

            public Object getKey() {
                return IdentityMapTest.this.key;
            }

            public Object getValue() {
                return IdentityMapTest.this.value;
            }

            public Object setValue(Object arg0) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void testConstructor_NullComparer() {
        try {
            new IdentityMap(null);
            IdentityMapTest.fail((String)"Constructor should throw exception when null comparer passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_NullCollection() {
        try {
            new IdentityMap(null);
            IdentityMapTest.fail((String)"Constructor should throw exception when null collection passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_ContainsAllEntries() {
        HashMap<Object, Object> toCopy = new HashMap<Object, Object>();
        toCopy.put(new Object(), new Object());
        this.map = new IdentityMap(toCopy);
        IdentityMapTest.assertEquals(toCopy, (Object)this.map);
    }

    public void testIsEmpty() {
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)this.map.isEmpty());
    }

    public void testSize() {
        IdentityMapTest.assertEquals((int)0, (int)this.map.size());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testClear() {
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testGet() {
        IdentityMapTest.assertNull((Object)this.map.get(this.key));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    public void testContainsKey() {
        String key1 = new String("key");
        String key2 = new String("key");
        IdentityMapTest.assertFalse((boolean)this.map.containsKey((Object)key1));
        this.map.put((Object)key1, this.value);
        IdentityMapTest.assertTrue((boolean)this.map.containsKey((Object)key1));
        IdentityMapTest.assertFalse((boolean)this.map.containsKey((Object)key2));
    }

    public void testContainsValue() {
        IdentityMapTest.assertFalse((boolean)this.map.containsValue(this.value));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)this.map.containsValue(this.value));
    }

    public void testPutAll() {
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.putAll(other);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)this.map.containsKey(this.key));
        IdentityMapTest.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    public void testRemove() {
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)this.map.containsKey(this.key));
        this.map.remove(this.key);
        IdentityMapTest.assertFalse((boolean)this.map.containsKey(this.key));
    }

    public void testValues() {
        Collection values = this.map.values();
        IdentityMapTest.assertTrue((boolean)values.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)values.size());
        IdentityMapTest.assertEquals((Object)this.value, values.iterator().next());
        this.map.remove(this.key);
        IdentityMapTest.assertTrue((boolean)this.map.values().isEmpty());
    }

    public void testKeySet() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)keySet.size());
        IdentityMapTest.assertTrue((boolean)keySet.contains(this.key));
        this.map.remove(this.key);
        IdentityMapTest.assertTrue((boolean)keySet.isEmpty());
    }

    public void testKeySet_Add() {
        try {
            this.map.keySet().add(this.key);
            IdentityMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testKeySet_AddAll() {
        try {
            this.map.keySet().addAll(Collections.singleton(this.key));
            IdentityMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testKeySet_Clear() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        IdentityMapTest.assertTrue((boolean)keySet.contains(this.key));
        keySet.clear();
        IdentityMapTest.assertTrue((boolean)keySet.isEmpty());
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_Contains() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertFalse((boolean)keySet.contains(this.key));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)keySet.contains(this.key));
    }

    public void testKeySet_ContainsAll() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertFalse((boolean)keySet.containsAll(Collections.singleton(this.key)));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)keySet.containsAll(Collections.singleton(this.key)));
    }

    public void testKeySet_IsEmpty() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)keySet.isEmpty());
    }

    public void testKeySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.keySet().iterator();
        IdentityMapTest.assertTrue((boolean)iterator.hasNext());
        IdentityMapTest.assertEquals((Object)this.key, iterator.next());
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        iterator.remove();
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
        IdentityMapTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testKeySet_Remove() {
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        this.map.keySet().remove(this.key);
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_RemoveAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        IdentityMapTest.assertFalse((boolean)keySet.removeAll(Collections.EMPTY_SET));
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)keySet.removeAll(Collections.singleton(this.key)));
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_RetainAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        IdentityMapTest.assertFalse((boolean)keySet.retainAll(Collections.singleton(this.key)));
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)keySet.retainAll(Collections.EMPTY_SET));
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_Size() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertEquals((int)0, (int)keySet.size());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)keySet.size());
        this.map.clear();
        IdentityMapTest.assertEquals((int)0, (int)keySet.size());
    }

    public void testKeySet_ToArray() {
        Set keySet = this.map.keySet();
        this.map.put(this.key, this.value);
        Object[] array = keySet.toArray();
        IdentityMapTest.assertEquals((int)1, (int)array.length);
        IdentityMapTest.assertSame((Object)this.key, (Object)array[0]);
    }

    public void testKeySet_ToArrayWithObjectArray() {
        this.key = new String("key");
        this.map.put(this.key, this.value);
        String[] array = this.map.keySet().toArray(new String[0]);
        IdentityMapTest.assertEquals((int)1, (int)array.length);
        IdentityMapTest.assertSame((Object)this.key, (Object)array[0]);
    }

    public void testKeySet_Equals() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertFalse((boolean)keySet.equals(null));
        IdentityMapTest.assertTrue((boolean)keySet.equals(keySet));
        IdentityMapTest.assertTrue((boolean)keySet.equals(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)keySet.equals(Collections.singleton(this.key)));
    }

    public void testKeySet_HashCode() {
        Set keySet = this.map.keySet();
        IdentityMapTest.assertEquals((int)0, (int)keySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.key.hashCode();
        IdentityMapTest.assertEquals((int)hash, (int)keySet.hashCode());
    }

    public void testEntrySet() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)entrySet.size());
        Map.Entry entry = (Map.Entry)entrySet.iterator().next();
        IdentityMapTest.assertEquals((Object)this.key, entry.getKey());
        IdentityMapTest.assertEquals((Object)this.value, entry.getValue());
        this.map.remove(this.key);
        IdentityMapTest.assertTrue((boolean)entrySet.isEmpty());
    }

    public void testEntrySet_Add() {
        try {
            this.map.entrySet().add(this.entry);
            IdentityMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testEntrySet_AddAll() {
        try {
            this.map.entrySet().addAll(Collections.EMPTY_SET);
            IdentityMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testEntrySet_Clear() {
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        this.map.entrySet().clear();
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_Contains() {
        this.map.put(this.key, this.value);
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertTrue((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
        this.map.remove(this.key);
        IdentityMapTest.assertFalse((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_ContainsAll() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertFalse((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        IdentityMapTest.assertTrue((boolean)entrySet.containsAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    public void testEntrySet_IsEmpty() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)entrySet.isEmpty());
    }

    public void testEntrySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.entrySet().iterator();
        IdentityMapTest.assertTrue((boolean)iterator.hasNext());
        Map.Entry entry = (Map.Entry)iterator.next();
        IdentityMapTest.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        iterator.remove();
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
        IdentityMapTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEntrySet_Remove() {
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)this.map.entrySet().remove(new MapEntryStub(this.key, this.value)));
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_RemoveAll() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertFalse((boolean)entrySet.removeAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)entrySet.removeAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_RetainAll() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertFalse((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertFalse((boolean)entrySet.retainAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        IdentityMapTest.assertEquals((int)1, (int)this.map.size());
        IdentityMapTest.assertTrue((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        IdentityMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_Size() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertEquals((int)0, (int)entrySet.size());
        this.map.put(this.key, this.value);
        IdentityMapTest.assertEquals((int)1, (int)entrySet.size());
    }

    public void testEntrySet_ToArray() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertEquals((int)0, (int)entrySet.toArray().length);
        this.map.put(this.key, this.value);
        Object[] array = entrySet.toArray();
        IdentityMapTest.assertEquals((int)1, (int)array.length);
        IdentityMapTest.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_ToArrayWithObjectArray() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertEquals((int)0, (int)entrySet.toArray(new Object[0]).length);
        this.map.put(this.key, this.value);
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        IdentityMapTest.assertEquals((int)1, (int)array.length);
        IdentityMapTest.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_Equals() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertFalse((boolean)entrySet.equals(null));
        IdentityMapTest.assertTrue((boolean)entrySet.equals(entrySet));
        IdentityMapTest.assertTrue((boolean)entrySet.equals(Collections.EMPTY_SET));
        IdentityMapTest.assertFalse((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)entrySet.equals(Collections.EMPTY_SET));
        IdentityMapTest.assertTrue((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    public void testEntrySet_HashCode() {
        Set entrySet = this.map.entrySet();
        IdentityMapTest.assertEquals((int)0, (int)entrySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.key.hashCode() ^ this.value.hashCode();
        IdentityMapTest.assertEquals((int)hash, (int)entrySet.hashCode());
    }

    public void testEntrySet_Entry_SetValue() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        Object newValue = new Object();
        Object oldValue = entry.setValue(newValue);
        IdentityMapTest.assertEquals((Object)this.value, (Object)oldValue);
        IdentityMapTest.assertEquals((Object)newValue, entry.getValue());
        IdentityMapTest.assertEquals((Object)newValue, (Object)this.map.get(this.key));
    }

    public void testEntrySet_Entry_Equals() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        IdentityMapTest.assertFalse((boolean)entry.equals(null));
        IdentityMapTest.assertTrue((boolean)entry.equals(entry));
        IdentityMapTest.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_Entry_HashCode() {
        this.map.put(this.key, this.value);
        int hash = this.key.hashCode() ^ this.value.hashCode();
        IdentityMapTest.assertEquals((int)hash, (int)this.map.entrySet().iterator().next().hashCode());
    }

    public void testEquals() {
        IdentityMapTest.assertFalse((boolean)this.map.equals(null));
        IdentityMapTest.assertTrue((boolean)this.map.equals((Object)this.map));
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        IdentityMapTest.assertTrue((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        IdentityMapTest.assertFalse((boolean)this.map.equals(other));
        this.map.put(this.key, this.value);
        IdentityMapTest.assertFalse((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        IdentityMapTest.assertTrue((boolean)this.map.equals(other));
    }

    public void testHashCode() {
        IdentityMapTest.assertEquals((int)0, (int)this.map.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.key.hashCode() ^ this.value.hashCode();
        IdentityMapTest.assertEquals((int)hash, (int)this.map.hashCode());
    }

    static class MapEntryStub
    implements Map.Entry {
        private final Object key;
        private final Object value;

        public MapEntryStub(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

