/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;

public class BeanObservableListDecoratorTest
extends TestCase {
    private Bean bean;
    private PropertyDescriptor propertyDescriptor;
    private IObservableList observableList;
    private BeanObservableListDecorator decorator;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new Bean();
        this.propertyDescriptor = new PropertyDescriptor("list", Bean.class, "getList", "setList");
        this.observableList = BeansObservables.observeList((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)"list");
        this.decorator = new BeanObservableListDecorator(this.observableList, this.propertyDescriptor);
    }

    public void testGetDelegate() throws Exception {
        BeanObservableListDecoratorTest.assertSame((Object)this.observableList, (Object)this.decorator.getDecorated());
    }

    public void testGetObserved() throws Exception {
        BeanObservableListDecoratorTest.assertSame((Object)this.bean, (Object)this.decorator.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        BeanObservableListDecoratorTest.assertSame((Object)this.propertyDescriptor, (Object)this.decorator.getPropertyDescriptor());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BeanObservableListDecoratorTest.class.getName());
        suite.addTestSuite(BeanObservableListDecoratorTest.class);
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private int counter;

        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList delegate = new WritableList(realm);
            int i = 0;
            while (i < elementCount) {
                delegate.add(this.createElement((IObservableCollection)delegate));
                ++i;
            }
            return new BeanObservableListDecorator((IObservableList)delegate, null);
        }

        public Object createElement(IObservableCollection collection) {
            return Integer.toString(this.counter++);
        }

        public void change(IObservable observable) {
            IObservableList list = (IObservableList)observable;
            list.add(this.createElement((IObservableCollection)list));
        }
    }
}

