/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.tests.internal.databinding.beans.BeanPropertyListenerSupportTest;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BeanValuePropertyTest
extends AbstractDefaultRealmTestCase {
    public void testChangeListenerIsOnlyNotifiedWhenWatchedPropertyChanges() throws Exception {
        BeanPropertyListenerSupportTest.GenericListenerBean bean = new BeanPropertyListenerSupportTest.GenericListenerBean();
        IBeanValueProperty property = BeanProperties.value(BeanPropertyListenerSupportTest.GenericListenerBean.class, (String)"value");
        class Listener
        implements IValueChangeListener {
            private int count = 0;

            Listener() {
            }

            public void handleValueChange(ValueChangeEvent event) {
                ++this.count;
            }
        }
        Listener listener = new Listener();
        IObservableValue observable = property.observe((Realm)new CurrentRealm(true), (Object)bean);
        observable.addValueChangeListener((IValueChangeListener)listener);
        BeanValuePropertyTest.assertEquals((int)0, (int)listener.count);
        bean.setValue("1");
        BeanValuePropertyTest.assertEquals((int)1, (int)listener.count);
        bean.setOther("2");
        BeanValuePropertyTest.assertEquals((int)1, (int)listener.count);
    }
}

