/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;

public class JavaBeanObservableArrayBasedSetTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet set;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private Bean bean;
    private String propertyName;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.propertyName = "array";
        this.propertyDescriptor = BeanProperties.set(Bean.class, (String)this.propertyName).getPropertyDescriptor();
        this.bean = new Bean(new HashSet());
        this.set = BeansObservables.observeSet((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.set;
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testRegistersListenerAfterFirstListenerIsAdded() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testRemovesListenerAfterLastListenerIsRemoved() throws Exception {
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.set.removeSetChangeListener((ISetChangeListener)listener);
        JavaBeanObservableArrayBasedSetTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testSetBeanProperty_FiresSetChangeEvents() throws Exception {
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.bean.setArray(new String[]{"element"});
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
    }

    public void testAdd_AddsElement() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)this.set.size());
        String element = "1";
        this.set.add((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)this.set.size());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)element, (Object)this.bean.getArray()[0]);
    }

    public void testAdd_SetChangeEvent() throws Exception {
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        String element = "1";
        this.set.add((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
        SetChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedSetTest.assertSame((Object)this.set, (Object)event.getObservableSet());
        JavaBeanObservableArrayBasedSetTest.assertEquals(Collections.singleton(element), (Object)event.diff.getAdditions());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)Collections.EMPTY_SET, (Object)event.diff.getRemovals());
    }

    public void testAdd_FiresPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            @Override
            public void run() {
                JavaBeanObservableArrayBasedSetTest.this.set.add((Object)"0");
            }
        });
    }

    public void testRemove() throws Exception {
        String element = "1";
        this.set.add((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)this.bean.getArray().length);
        this.set.remove((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)this.bean.getArray().length);
    }

    public void testRemove_SetChangeEvent() throws Exception {
        String element = "1";
        this.set.add((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)this.set.size());
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.set.remove((Object)element);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
        SetChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.set, (Object)event.getObservableSet());
        JavaBeanObservableArrayBasedSetTest.assertEquals(Collections.singleton(element), (Object)event.diff.getRemovals());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)Collections.EMPTY_SET, (Object)event.diff.getAdditions());
    }

    public void testRemovePropertyChangeEvent() throws Exception {
        this.set.add((Object)"0");
        JavaBeanObservableArrayBasedSetTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            @Override
            public void run() {
                JavaBeanObservableArrayBasedSetTest.this.set.remove((Object)"0");
            }
        });
    }

    public void testAddAll() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)this.set.size());
        this.set.addAll(elements);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)2, (int)this.bean.getArray().length);
    }

    public void testAddAll_SetChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)this.set.size());
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.set.addAll(elements);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
        SetChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.set, (Object)event.getObservableSet());
        JavaBeanObservableArrayBasedSetTest.assertEquals(new HashSet<String>(elements), (Object)event.diff.getAdditions());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)Collections.EMPTY_SET, (Object)event.diff.getRemovals());
    }

    public void testAddAllPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedSetTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            @Override
            public void run() {
                JavaBeanObservableArrayBasedSetTest.this.set.addAll(Arrays.asList("0", "1"));
            }
        });
    }

    public void testRemoveAll() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.set.addAll(elements);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)2, (int)this.bean.getArray().length);
        this.set.removeAll(elements);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)this.bean.getArray().length);
    }

    public void testRemoveAll_SetChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.set.addAll(elements);
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.set.removeAll(elements);
        SetChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.set, (Object)event.getObservableSet());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)Collections.EMPTY_SET, (Object)event.diff.getAdditions());
        JavaBeanObservableArrayBasedSetTest.assertEquals(new HashSet<String>(elements), (Object)event.diff.getRemovals());
    }

    public void testRemoveAllPropertyChangeEvent() throws Exception {
        this.set.add((Object)"0");
        JavaBeanObservableArrayBasedSetTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            @Override
            public void run() {
                JavaBeanObservableArrayBasedSetTest.this.set.removeAll(Arrays.asList("0"));
            }
        });
    }

    public void testRetainAll() throws Exception {
        this.set.addAll(Arrays.asList("0", "1", "2", "3"));
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)4, (int)this.bean.getArray().length);
        this.set.retainAll(Arrays.asList("0", "1"));
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)2, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedSetTest.assertTrue((boolean)this.set.containsAll(Arrays.asList("1", "0")));
    }

    public void testRetainAll_SetChangeEvent() throws Exception {
        this.set.addAll(Arrays.asList("0", "1", "2", "3"));
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.set.retainAll(Arrays.asList("0", "1"));
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
        SetChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)this.set, (Object)event.getObservableSet());
        JavaBeanObservableArrayBasedSetTest.assertEquals((Object)Collections.EMPTY_SET, (Object)event.diff.getAdditions());
        JavaBeanObservableArrayBasedSetTest.assertEquals(new HashSet<String>(Arrays.asList("2", "3")), (Object)event.diff.getRemovals());
    }

    public void testRetainAllPropertyChangeEvent() throws Exception {
        this.set.addAll(Arrays.asList("0", "1"));
        JavaBeanObservableArrayBasedSetTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            @Override
            public void run() {
                JavaBeanObservableArrayBasedSetTest.this.set.retainAll(Arrays.asList("0"));
            }
        });
    }

    public void testSetChangeEventFiresWhenNewSetIsSet() throws Exception {
        Object[] elements = new Bean[]{new Bean(), new Bean()};
        SetChangeEventTracker listener = SetChangeEventTracker.observe((IObservableSet)this.set);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        this.bean.setArray(elements);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)listener.count);
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setArray(new Object[]{"old"});
        IObservableSet observable = BeansObservables.observeSet((Realm)new CurrentRealm(true), (Object)bean, (String)"array");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        ((Bean)bean).setArray(new Object[]{"new"});
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableArrayBasedSetTest.assertEquals(Collections.singleton("old"), (Object)tracker.event.diff.getRemovals());
        JavaBeanObservableArrayBasedSetTest.assertEquals(Collections.singleton("new"), (Object)tracker.event.diff.getAdditions());
    }

    public void testModifyObservableSet_FiresSetChange() {
        Bean bean = new Bean(new Object[0]);
        IObservableSet observable = BeansObservables.observeSet((Object)bean, (String)"array");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        observable.add((Object)"new");
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableArrayBasedSetTest.assertDiff(tracker.event.diff, Collections.EMPTY_SET, Collections.singleton("new"));
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(new Object[0]);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableSet observable = BeansObservables.observeSet((Realm)realm, (Object)bean, (String)"array");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        realm.setCurrent(false);
        bean.setArray(new Object[]{"element"});
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableArrayBasedSetTest.assertDiff(tracker.event.diff, Collections.EMPTY_SET, Collections.singleton("element"));
    }

    private static void assertDiff(SetDiff diff, Set oldSet, Set newSet) {
        oldSet = new HashSet(oldSet);
        diff.applyTo(oldSet);
        JavaBeanObservableArrayBasedSetTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newSet, oldSet);
    }

    private static void assertPropertyChangeEvent(Bean bean, Runnable runnable) {
        PropertyChangeTracker listener = new PropertyChangeTracker();
        bean.addPropertyChangeListener(listener);
        Object[] old = bean.getArray();
        JavaBeanObservableArrayBasedSetTest.assertEquals((int)0, (int)listener.count);
        runnable.run();
        PropertyChangeEvent event = listener.evt;
        JavaBeanObservableArrayBasedSetTest.assertEquals((String)"event did not fire", (int)1, (int)listener.count);
        JavaBeanObservableArrayBasedSetTest.assertEquals((String)"array", (String)event.getPropertyName());
        JavaBeanObservableArrayBasedSetTest.assertTrue((String)"old value", (boolean)Arrays.equals(old, (Object[])event.getOldValue()));
        JavaBeanObservableArrayBasedSetTest.assertTrue((String)"new value", (boolean)Arrays.equals(bean.getArray(), (Object[])event.getNewValue()));
        JavaBeanObservableArrayBasedSetTest.assertFalse((String)"sets are equal", (boolean)Arrays.equals(bean.getArray(), old));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JavaBeanObservableArrayBasedSetTest.class.getName());
        suite.addTestSuite(JavaBeanObservableArrayBasedSetTest.class);
        suite.addTest(MutableObservableSetContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            String propertyName = "array";
            Bean bean = new Bean(new Object[0]);
            IObservableSet set = BeansObservables.observeSet((Realm)realm, (Object)bean, (String)propertyName, String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(this.createElement((IObservableCollection)set));
                ++i;
            }
            return set;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object().toString();
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public void change(IObservable observable) {
            IObservableSet set = (IObservableSet)observable;
            set.add(this.createElement((IObservableCollection)set));
        }
    }

    private static class PropertyChangeTracker
    implements PropertyChangeListener {
        int count;
        PropertyChangeEvent evt;

        private PropertyChangeTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.evt = evt;
        }
    }
}

