/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.tests.databinding.observable.ThreadRealm;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class JavaBeanObservableMapTest
extends AbstractDefaultRealmTestCase {
    private Bean model1;
    private Bean model2;
    private WritableSet set;
    private PropertyDescriptor propertyDescriptor;
    private IObservableMap map;
    private IBeanObservable beanObservable;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ThreadRealm realm = new ThreadRealm();
        realm.init(Thread.currentThread());
        this.model1 = new Bean("1");
        this.model2 = new Bean("2");
        this.set = new WritableSet((Realm)realm, new HashSet(), Bean.class);
        this.set.add((Object)this.model1);
        this.set.add((Object)this.model2);
        String propertyName = "value";
        this.propertyDescriptor = BeanProperties.value(Bean.class, (String)propertyName).getPropertyDescriptor();
        this.map = BeansObservables.observeMap((IObservableSet)this.set, Bean.class, (String)propertyName);
        this.beanObservable = (IBeanObservable)this.map;
    }

    public void testGetValue() throws Exception {
        JavaBeanObservableMapTest.assertEquals((String)"The 'value' from the map should be the value of the property of the model.", (Object)this.model1.getValue(), (Object)this.map.get((Object)this.model1));
    }

    public void testGetValue_KeyOutOfDomain() {
        Bean model3 = new Bean("3");
        JavaBeanObservableMapTest.assertFalse((boolean)this.map.containsKey((Object)model3));
        JavaBeanObservableMapTest.assertFalse((boolean)model3.getValue().equals(this.map.get((Object)model3)));
    }

    public void testSetValueNotifications() throws Exception {
        String oldValue = this.model1.getValue();
        String newValue = String.valueOf(this.model1.getValue()) + this.model1.getValue();
        MapChangeEventTracker listener = new MapChangeEventTracker();
        this.map.addMapChangeListener((IMapChangeListener)listener);
        JavaBeanObservableMapTest.assertEquals((int)0, (int)listener.count);
        this.model1.setValue(newValue);
        JavaBeanObservableMapTest.assertEquals((int)1, (int)listener.count);
        JavaBeanObservableMapTest.assertTrue((boolean)listener.event.diff.getChangedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertEquals((Object)newValue, (Object)listener.event.diff.getNewValue((Object)this.model1));
        JavaBeanObservableMapTest.assertEquals((Object)oldValue, (Object)listener.event.diff.getOldValue((Object)this.model1));
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getAddedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getRemovedKeys().contains(this.model1));
    }

    public void testPutValue() throws Exception {
        String oldValue = this.model1.getValue();
        String newValue = String.valueOf(this.model1.getValue()) + this.model1.getValue();
        MapChangeEventTracker listener = new MapChangeEventTracker();
        this.map.addMapChangeListener((IMapChangeListener)listener);
        JavaBeanObservableMapTest.assertEquals((int)0, (int)listener.count);
        this.map.put((Object)this.model1, (Object)newValue);
        JavaBeanObservableMapTest.assertEquals((int)1, (int)listener.count);
        JavaBeanObservableMapTest.assertEquals((String)newValue, (String)this.model1.getValue());
        JavaBeanObservableMapTest.assertEquals((Object)oldValue, (Object)listener.event.diff.getOldValue((Object)this.model1));
        JavaBeanObservableMapTest.assertEquals((Object)newValue, (Object)listener.event.diff.getNewValue((Object)this.model1));
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getAddedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertTrue((boolean)listener.event.diff.getChangedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getRemovedKeys().contains(this.model1));
    }

    public void testAddKey() throws Exception {
        MapChangeEventTracker listener = new MapChangeEventTracker();
        this.map.addMapChangeListener((IMapChangeListener)listener);
        Bean model3 = new Bean("3");
        JavaBeanObservableMapTest.assertEquals((int)0, (int)listener.count);
        this.set.add((Object)model3);
        JavaBeanObservableMapTest.assertEquals((int)1, (int)listener.count);
        JavaBeanObservableMapTest.assertTrue((boolean)listener.event.diff.getAddedKeys().contains(model3));
        JavaBeanObservableMapTest.assertEquals((Object)model3.getValue(), (Object)this.map.get((Object)model3));
        String newValue = String.valueOf(model3.getValue()) + model3.getValue();
        model3.setValue(newValue);
        JavaBeanObservableMapTest.assertEquals((int)2, (int)listener.count);
        JavaBeanObservableMapTest.assertEquals((int)3, (int)this.map.size());
    }

    public void testRemoveKey() throws Exception {
        MapChangeEventTracker listener = new MapChangeEventTracker();
        this.map.addMapChangeListener((IMapChangeListener)listener);
        JavaBeanObservableMapTest.assertEquals((int)0, (int)listener.count);
        this.set.remove((Object)this.model1);
        JavaBeanObservableMapTest.assertEquals((int)1, (int)listener.count);
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getAddedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertFalse((boolean)listener.event.diff.getChangedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertTrue((boolean)listener.event.diff.getRemovedKeys().contains(this.model1));
        JavaBeanObservableMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableMapTest.assertEquals((Object)this.set, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableMapTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testConstructor_SkipRegisterListeners() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        WritableSet set = new WritableSet((Realm)realm);
        Bean bean = new Bean();
        set.add((Object)bean);
        IObservableMap observable = PojoObservables.observeMap((IObservableSet)set, Bean.class, (String)"value");
        JavaBeanObservableMapTest.assertFalse((boolean)bean.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableMapTest.assertFalse((boolean)bean.hasListeners("value"));
    }

    public void testConstructor_RegistersListeners() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        WritableSet set = new WritableSet((Realm)realm);
        Bean bean = new Bean();
        set.add((Object)bean);
        IObservableMap observable = BeansObservables.observeMap((IObservableSet)set, Bean.class, (String)"value");
        JavaBeanObservableMapTest.assertFalse((boolean)bean.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableMapTest.assertTrue((boolean)bean.hasListeners("value"));
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        WritableSet set = new WritableSet((Realm)new CurrentRealm(true));
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setValue("old");
        set.add((Object)bean);
        IObservableMap map = BeansObservables.observeMap((IObservableSet)set, Bean.class, (String)"value");
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        ((Bean)bean).setValue("new");
        JavaBeanObservableMapTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)tracker.event.diff.getAddedKeys());
        JavaBeanObservableMapTest.assertEquals(Collections.singleton(bean), (Object)tracker.event.diff.getChangedKeys());
        JavaBeanObservableMapTest.assertEquals((Object)Collections.EMPTY_SET, (Object)tracker.event.diff.getRemovedKeys());
        JavaBeanObservableMapTest.assertEquals((Object)"old", (Object)tracker.event.diff.getOldValue((Object)bean));
        JavaBeanObservableMapTest.assertEquals((Object)"new", (Object)tracker.event.diff.getNewValue((Object)bean));
    }

    public void testModifyObservableMap_FiresMapChange() {
        Bean bean = new Bean(Collections.singletonMap("key", "oldValue"));
        IObservableMap observable = BeansObservables.observeMap((Object)bean, (String)"map");
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)observable);
        observable.put((Object)"key", (Object)"newValue");
        JavaBeanObservableMapTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableMapTest.assertDiff(tracker.event.diff, Collections.singletonMap("key", "oldValue"), Collections.singletonMap("key", "newValue"));
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(Collections.EMPTY_MAP);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableMap observable = BeansObservables.observeMap((Realm)realm, (Object)bean, (String)"map");
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)observable);
        realm.setCurrent(false);
        bean.setMap(Collections.singletonMap("key", "value"));
        JavaBeanObservableMapTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableMapTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableMapTest.assertDiff(tracker.event.diff, Collections.EMPTY_MAP, Collections.singletonMap("key", "value"));
    }

    private static void assertDiff(MapDiff diff, Map oldMap, Map newMap) {
        oldMap = new HashMap(oldMap);
        diff.applyTo(oldMap);
        JavaBeanObservableMapTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newMap, oldMap);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JavaBeanObservableMapTest.class.getName());
        suite.addTestSuite(JavaBeanObservableMapTest.class);
        return suite;
    }
}

