/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;

public class JavaBeanObservableSetTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet observableSet;
    private IBeanObservable beanObservable;
    private Bean bean;
    private PropertyDescriptor propertyDescriptor;
    private String propertyName;
    private SetChangeEventTracker listener;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new Bean();
        this.propertyName = "set";
        this.propertyDescriptor = BeanProperties.set(Bean.class, (String)this.propertyName).getPropertyDescriptor();
        this.observableSet = BeansObservables.observeSet((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)this.propertyName, Bean.class);
        this.beanObservable = (IBeanObservable)this.observableSet;
        this.listener = new SetChangeEventTracker();
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableSetTest.assertEquals((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableSetTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testGetElementType() throws Exception {
        JavaBeanObservableSetTest.assertEquals(Bean.class, (Object)this.observableSet.getElementType());
    }

    public void testRegistersListenerAfterFirstListenerIsAdded() throws Exception {
        JavaBeanObservableSetTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.observableSet.addSetChangeListener((ISetChangeListener)new SetChangeEventTracker());
        JavaBeanObservableSetTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testRemovesListenerAfterLastListenerIsRemoved() throws Exception {
        this.observableSet.addSetChangeListener((ISetChangeListener)this.listener);
        JavaBeanObservableSetTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.observableSet.removeSetChangeListener((ISetChangeListener)this.listener);
        JavaBeanObservableSetTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testFiresChangeEvents() throws Exception {
        this.observableSet.addSetChangeListener((ISetChangeListener)this.listener);
        JavaBeanObservableSetTest.assertEquals((int)0, (int)this.listener.count);
        this.bean.setSet(new HashSet<String>(Arrays.asList("1")));
        JavaBeanObservableSetTest.assertEquals((int)1, (int)this.listener.count);
    }

    public void testConstructor_RegisterListeners() throws Exception {
        this.bean = new Bean();
        this.observableSet = BeansObservables.observeSet((Realm)new CurrentRealm(true), (Object)this.bean, (String)this.propertyName);
        JavaBeanObservableSetTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        ChangeEventTracker.observe((IObservable)this.observableSet);
        JavaBeanObservableSetTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testConstructor_SkipsRegisterListeners() throws Exception {
        this.bean = new Bean();
        this.observableSet = PojoObservables.observeSet((Realm)new CurrentRealm(true), (Object)this.bean, (String)this.propertyName);
        JavaBeanObservableSetTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        ChangeEventTracker.observe((IObservable)this.observableSet);
        JavaBeanObservableSetTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setSet(Collections.singleton("old"));
        IObservableSet observable = BeansObservables.observeSet((Realm)new CurrentRealm(true), (Object)bean, (String)"set");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        ((Bean)bean).setSet(Collections.singleton("new"));
        JavaBeanObservableSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableSetTest.assertEquals(Collections.singleton("old"), (Object)tracker.event.diff.getRemovals());
        JavaBeanObservableSetTest.assertEquals(Collections.singleton("new"), (Object)tracker.event.diff.getAdditions());
    }

    public void testModifyObservableSet_FiresSetChange() {
        Bean bean = new Bean(new HashSet());
        IObservableSet observable = BeansObservables.observeSet((Object)bean, (String)"set");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        Object element = new Object();
        observable.add(element);
        JavaBeanObservableSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableSetTest.assertDiff(tracker.event.diff, Collections.EMPTY_SET, Collections.singleton(element));
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(Collections.EMPTY_SET);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableSet observable = BeansObservables.observeSet((Realm)realm, (Object)bean, (String)"set");
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)observable);
        realm.setCurrent(false);
        bean.setSet(Collections.singleton("element"));
        JavaBeanObservableSetTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableSetTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableSetTest.assertDiff(tracker.event.diff, Collections.EMPTY_SET, Collections.singleton("element"));
    }

    public void testUpdatedBeanSetIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableSet observable = BeansObservables.observeSet((Object)bean, (String)"set");
        observable.add(new Object());
        bean.getSet().clear();
    }

    public void testUpdatedPojoSetIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableSet observable = PojoObservables.observeSet((Object)bean, (String)"set");
        observable.add(new Object());
        bean.getSet().clear();
    }

    private static void assertDiff(SetDiff diff, Set oldSet, Set newSet) {
        oldSet = new HashSet(oldSet);
        diff.applyTo(oldSet);
        JavaBeanObservableSetTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newSet, oldSet);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JavaBeanObservableSetTest.class.getName());
        suite.addTestSuite(JavaBeanObservableSetTest.class);
        suite.addTest(MutableObservableSetContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            Bean bean = new Bean();
            String propertyName = "set";
            IObservableSet set = BeansObservables.observeSet((Realm)realm, (Object)bean, (String)propertyName, String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(this.createElement((IObservableCollection)set));
                ++i;
            }
            return set;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public void change(IObservable observable) {
            IObservableSet set = (IObservableSet)observable;
            set.add(this.createElement((IObservableCollection)set));
        }
    }
}

