/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;

public class IdentityConverterTest
extends TestCase {
    private IdentityConverter c;

    protected void setUp() throws Exception {
        this.c = new IdentityConverter(Integer.TYPE, Integer.TYPE);
    }

    public void testIsPrimitiveTypeMatchedWithBoxed() throws Exception {
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Integer.class, Integer.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Integer.TYPE, Integer.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Byte.class, Byte.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Byte.TYPE, Byte.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Short.class, Short.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Short.TYPE, Short.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Long.class, Long.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Long.TYPE, Long.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Float.class, Float.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Float.TYPE, Float.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Double.class, Double.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Double.TYPE, Double.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.class, Boolean.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.TYPE, Boolean.class));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Character.class, Character.TYPE));
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Character.TYPE, Character.class));
        IdentityConverterTest.assertFalse((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.class, Integer.TYPE));
    }

    public void testConvert_NullToPrimitive() {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        try {
            p2b.convert(null);
            IdentityConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (BindingException bindingException) {}
    }

    public void testConvert_PrimitiveToBoxed() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.class);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_BoxedToPrimitive() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.class, Float.TYPE);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_PrimitiveToPrimitive() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_BoxedToBoxed() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.class, Float.class);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void test_Convert_ValidAssignment() throws Exception {
        IdentityConverter pc = new IdentityConverter(Object.class, Person.class);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        IdentityConverterTest.assertTrue((String)"Person class", (boolean)person.getClass().equals(Person.class));
        IdentityConverterTest.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    public void test_Convert_ValidAssignment2() throws Exception {
        IdentityConverter pc = new IdentityConverter(Person.class, Object.class);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        IdentityConverterTest.assertTrue((String)"Person class", (boolean)person.getClass().equals(Person.class));
        IdentityConverterTest.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    public void testConvert_InvalidAssignment() throws Exception {
        IdentityConverter pc = new IdentityConverter(Object.class, Person.class);
        try {
            pc.convert((Object)new Animal());
            IdentityConverterTest.fail((String)"Should have gotten an exception");
        }
        catch (Exception exception) {}
    }

    public static class Animal {
        public String name = "fido";
    }

    public static class Person {
        public String foo = "blah";
    }
}

