/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter;

public class IntegerToStringConverterTest
extends TestCase {
    private NumberFormat integerFormat;

    protected void setUp() throws Exception {
        super.setUp();
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    public void testFromTypeShort() throws Exception {
        IntegerToStringConverterTest.assertEquals(Short.class, (Object)IntegerToStringConverter.fromShort((boolean)false).getFromType());
        IntegerToStringConverterTest.assertEquals(Short.TYPE, (Object)IntegerToStringConverter.fromShort((boolean)true).getFromType());
        IntegerToStringConverterTest.assertEquals(Byte.class, (Object)IntegerToStringConverter.fromByte((boolean)false).getFromType());
        IntegerToStringConverterTest.assertEquals(Byte.TYPE, (Object)IntegerToStringConverter.fromByte((boolean)true).getFromType());
    }

    public void testToTypeIsStringClass() throws Exception {
        IntegerToStringConverterTest.assertEquals(String.class, (Object)IntegerToStringConverter.fromShort((boolean)false).getToType());
    }

    public void testConvertShortToString() throws Exception {
        Short value = new Short(1);
        String expected = this.integerFormat.format((Object)value);
        IntegerToStringConverter converter = IntegerToStringConverter.fromShort((NumberFormat)this.integerFormat, (boolean)false);
        String result = (String)converter.convert((Object)value);
        IntegerToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertByteToString() throws Exception {
        Byte value = new Byte(1);
        String expected = this.integerFormat.format((Object)value);
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((NumberFormat)this.integerFormat, (boolean)false);
        String result = (String)converter.convert((Object)value);
        IntegerToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testNullSourceConvertsToEmptyString() throws Exception {
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((boolean)false);
        IntegerToStringConverterTest.assertEquals((Object)"", (Object)converter.convert(null));
    }

    public void testIllegalArgumentExceptionIfSourceIsNotExpectedType() throws Exception {
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((boolean)false);
        try {
            converter.convert((Object)1);
            IntegerToStringConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

