/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.IConverter;

public abstract class NumberToNumberTestHarness
extends TestCase {
    protected abstract IConverter doGetToPrimitiveValidator(Class var1);

    protected abstract IConverter doGetToBoxedTypeValidator(Class var1);

    protected abstract Class doGetToType(boolean var1);

    protected abstract Number doGetOutOfRangeNumber();

    public void testFromType() throws Exception {
        Class<Integer> from = Integer.class;
        NumberToNumberTestHarness.assertEquals(from, (Object)this.doGetToBoxedTypeValidator(from).getFromType());
    }

    public void testToTypeIsPrimitive() throws Exception {
        Class toType = this.doGetToType(true);
        if (toType == null) {
            return;
        }
        NumberToNumberTestHarness.assertEquals((String)"to type was not of the correct type", (Object)toType, (Object)this.doGetToPrimitiveValidator(Integer.class).getToType());
        NumberToNumberTestHarness.assertTrue((String)"to type was not primitive", (boolean)toType.isPrimitive());
    }

    public void testToTypeIsBoxedType() throws Exception {
        Class toType = this.doGetToType(false);
        NumberToNumberTestHarness.assertEquals((Object)toType, (Object)this.doGetToBoxedTypeValidator(Integer.class).getToType());
        NumberToNumberTestHarness.assertFalse((boolean)toType.isPrimitive());
    }

    public void testValidConversion() throws Exception {
        Integer value = 1;
        Number result = (Number)this.doGetToBoxedTypeValidator(Integer.class).convert((Object)value);
        NumberToNumberTestHarness.assertNotNull((String)"result was null", (Object)result);
        NumberToNumberTestHarness.assertEquals((Object)this.doGetToType(false), result.getClass());
        NumberToNumberTestHarness.assertEquals((Object)value, (Object)result.intValue());
    }

    public void testOutOfRangeConversion() throws Exception {
        Number outOfRange = this.doGetOutOfRangeNumber();
        if (outOfRange == null) {
            return;
        }
        try {
            this.doGetToBoxedTypeValidator(Integer.class).convert((Object)outOfRange);
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testConvertNullValueForPrimitiveThrowsIllegalArgumentException() throws Exception {
        if (this.doGetToType(true) == null) {
            return;
        }
        try {
            this.doGetToPrimitiveValidator(Integer.class).convert(null);
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testConvertNullValueForBoxedTypeReturnsNull() throws Exception {
        NumberToNumberTestHarness.assertNull((Object)this.doGetToBoxedTypeValidator(Integer.class).convert(null));
    }

    public void testNonNumberThrowsIllegalArgumentException() throws Exception {
        try {
            this.doGetToBoxedTypeValidator(Integer.class).convert((Object)"");
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

