/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.conversion.StatusToStringConverter;
import org.eclipse.core.runtime.IStatus;

public class StatusToStringConverterTest
extends TestCase {
    private StatusToStringConverter converter;

    protected void setUp() throws Exception {
        super.setUp();
        this.converter = new StatusToStringConverter();
    }

    public void testConvertedValueIsMessageOfStatus() throws Exception {
        String message = "this is my message";
        IStatus status = ValidationStatus.error((String)message);
        StatusToStringConverterTest.assertEquals((Object)message, (Object)this.converter.convert((Object)status));
    }

    public void testFromTypeIsIStatus() throws Exception {
        StatusToStringConverterTest.assertEquals(IStatus.class, (Object)this.converter.getFromType());
    }

    public void testToTypeIsString() throws Exception {
        StatusToStringConverterTest.assertEquals(String.class, (Object)this.converter.getToType());
    }

    public void testIllegalArgumentExceptionIsThrownWithNullInput() throws Exception {
        try {
            this.converter.convert(null);
            StatusToStringConverterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

