/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;

public class StringToByteConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private StringToByteConverter converter;

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)false);
    }

    public void testConvertsToByte() throws Exception {
        Byte value = new Byte(1);
        Byte result = (Byte)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToByteConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testConvertsToBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)true);
        Byte value = new Byte(1);
        Byte result = (Byte)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToByteConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testFromTypeIsString() throws Exception {
        StringToByteConverterTest.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    public void testToTypeIsShort() throws Exception {
        StringToByteConverterTest.assertEquals(Byte.class, (Object)this.converter.getToType());
    }

    public void testToTypeIsBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((boolean)true);
        StringToByteConverterTest.assertEquals(Byte.TYPE, (Object)this.converter.getToType());
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToByteConverterTest.assertNull((Object)this.converter.convert((Object)""));
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)1);
            StringToByteConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

