/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;

public class StringToCharacterConverterTest
extends TestCase {
    private StringToCharacterConverter converter;
    private StringToCharacterConverter primitiveConverter;

    protected void setUp() throws Exception {
        super.setUp();
        this.converter = StringToCharacterConverter.toCharacter((boolean)false);
        this.primitiveConverter = StringToCharacterConverter.toCharacter((boolean)true);
    }

    public void testConvertsToCharacter() throws Exception {
        Character value = new Character('X');
        Character result = (Character)this.converter.convert((Object)Character.toString(value.charValue()));
        StringToCharacterConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testConvertsToCharacterPrimitive() throws Exception {
        Character value = new Character('Y');
        Character result = (Character)this.primitiveConverter.convert((Object)String.valueOf(value.charValue()));
        StringToCharacterConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testFromTypeIsString() throws Exception {
        StringToCharacterConverterTest.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    public void testToTypeIsCharacter() throws Exception {
        StringToCharacterConverterTest.assertEquals(Character.class, (Object)this.converter.getToType());
    }

    public void testToTypeIsCharacterPrimitive() throws Exception {
        StringToCharacterConverterTest.assertEquals(Character.TYPE, (Object)this.primitiveConverter.getToType());
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToCharacterConverterTest.assertNull((Object)this.converter.convert((Object)""));
    }

    public void testNullCharacterIsOK() throws Exception {
        StringToCharacterConverterTest.assertNull((Object)this.converter.convert(null));
    }

    public void testNullCharacterIsNotOKForPrimitive() throws Exception {
        try {
            this.primitiveConverter.convert(null);
            StringToCharacterConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)1);
            StringToCharacterConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

