/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;

public class StringToNumberParserTest
extends TestCase {
    private NumberFormat integerFormat;

    protected void setUp() throws Exception {
        super.setUp();
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    public void testParseNonStringThrowsIllegalArgumentException() throws Exception {
        try {
            StringToNumberParser.parse((Object)0, (NumberFormat)this.integerFormat, (boolean)false);
            StringToNumberParserTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testEmptyStringReturnsNullIfNotPrimitive() throws Exception {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"", (NumberFormat)this.integerFormat, (boolean)false);
        StringToNumberParserTest.assertNull((Object)result.getNumber());
    }

    public void testReturnsParsePositionWhenValueCannotBeParsed() throws Exception {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"adsf", (NumberFormat)this.integerFormat, (boolean)false);
        StringToNumberParserTest.assertNotNull((Object)result.getPosition());
        StringToNumberParserTest.assertNull((Object)result.getNumber());
    }

    public void testReturnsNumberWhenSuccessfullyParsed() throws Exception {
        Integer number = 5;
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)this.integerFormat.format(number.longValue()), (NumberFormat)this.integerFormat, (boolean)false);
        StringToNumberParserTest.assertNull((Object)result.getPosition());
        StringToNumberParserTest.assertEquals((int)number, (int)result.getNumber().intValue());
    }
}

