/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;

public class StringToShortConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private StringToShortConverter converter;

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)false);
    }

    public void testConvertsToShort() throws Exception {
        Short value = new Short(1);
        Short result = (Short)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToShortConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testConvertsToShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)true);
        Short value = new Short(1);
        Short result = (Short)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToShortConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testFromTypeIsString() throws Exception {
        StringToShortConverterTest.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    public void testToTypeIsShort() throws Exception {
        StringToShortConverterTest.assertEquals(Short.class, (Object)this.converter.getToType());
    }

    public void testToTypeIsShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((boolean)true);
        StringToShortConverterTest.assertEquals(Short.TYPE, (Object)this.converter.getToType());
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToShortConverterTest.assertNull((Object)this.converter.convert((Object)""));
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)1);
            StringToShortConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

