/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.observable.ConstantObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ConstantObservableValueTest
extends AbstractDefaultRealmTestCase {
    public void testConstructor_NullRealm() {
        try {
            new ConstantObservableValue(null, null, null);
            ConstantObservableValueTest.fail((String)"Constructor should throw an exception when null realm is passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConstantValueTest");
        suite.addTestSuite(ConstantObservableValueTest.class);
        suite.addTest(UnchangeableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            return new ConstantObservableValue(realm, new Object(), Object.class);
        }

        public Object getValueType(IObservableValue observable) {
            return Object.class;
        }
    }

    public static class UnchangeableObservableValueContractTest
    extends ObservableValueContractTest {
        public UnchangeableObservableValueContractTest(String name, IObservableValueContractDelegate delegate) {
            super(name, delegate);
        }

        public void testChange_OrderOfNotifications() {
        }

        public void testChange_ValueChangeEvent() {
        }

        public void testChange_ValueChangeEventDiff() {
        }

        public void testChange_ValueChangeEventFiredAfterValueIsSet() {
        }

        public void testRemoveValueChangeListener_RemovesListener() throws Exception {
        }

        public void testChange_ChangeEvent() {
        }

        public void testChange_EventObservable() {
        }

        public void testChange_ObservableRealmIsTheCurrentRealm() {
        }

        public void testChange_RealmCheck() {
        }

        public void testRemoveChangeListener_RemovesListener() {
        }

        public void testIsStale_RealmChecks() {
        }

        public void testIsStale_GetterCalled() throws Exception {
        }

        public void testIsDisposed() throws Exception {
        }

        public void testAddDisposeListener_HandleDisposeInvoked() {
        }

        public static Test suite(IObservableValueContractDelegate delegate) {
            return new SuiteBuilder().addObservableContractTest(UnchangeableObservableValueContractTest.class, (IObservableContractDelegate)delegate).build();
        }
    }
}

